import json


def load_json(filename):
    with open(filename, 'r') as f:
        data = json.load(f)
    return data


def load_jsonl(filename):
    with open(filename, 'r') as f:
        data = [json.loads(line) for line in f]
    return data


def save_jsonl(data, filename='dataset.jsonl'):
    with open(filename, 'w') as f:
        for item in data:
            # Serialize each dictionary to a JSON-formatted string
            json_string = json.dumps(item)
            # Write each JSON string to a new line in the file
            f.write(json_string + '\n')


def convert_text_to_json(input_text, required_keys=["description", "meta", "reasoning", "decision"]):
    # Define the structure of the JSON object we are looking for
    try:
        # Attempt to load the text as JSON
        json_data = json.loads(input_text)
        # Check if all required keys exist in the JSON object
        if all(key in json_data for key in required_keys):
            # If yes, return the JSON object as is
            return json_data
        else:
            # If not all required keys are present, return None
            return None
    except json.JSONDecodeError:
        # If the text is not valid JSON, return None
        print('Fail to convert text to json.')
        return None


def wrap_json(data, system_prompt, input_format, output_format):
    meta = data['meta']
    description = data['description']
    reasoning = data['reasoning']
    decision = data['decision']
    messages = [
        {"role": "system", "content": system_prompt},
        {"role": "user", "content": input_format.format(meta=meta, description=description)},
        {"role": "assistant", "content": output_format.format(reasoning, decision)}
    ]
    return messages


def convert_format(data: dict):
    """Convert OpenAI fine-tuning format to Google fine-tuning format
    :param data:
    """
    assert isinstance(data, dict), 'Input data should be a list.'
    system_prompt = data['messages'][0]['content']
    question = data['messages'][1]['content']
    answer = data['messages'][2]['content']
    new_data = {
        'input_text': f"Context: {system_prompt}Question: {question}",
        'output_text': answer
    }
    return new_data