# Dataset

## DataSheet

| Name                                      | Split | Description                                                                                    |
|-------------------------------------------|-------|------------------------------------------------------------------------------------------------|
| nusc_train_dataset                        | Train | The benign training dataset of the nuScenes dataset.                                           |
| nusc_train_rag_dataset                    | RAG   | The RAG example sets used for retrieve ICL examples for build fine-tuning data.                |
| nusc_eval_rag_dataset                     | RAG   | The RAG example sets used for retrieve ICL examples for evaluation. Add target scenario in it. |
| nusc_eval_dataset                         | Test  | The benign testing dataset of the nuScenes dataset.                                            |
| nusc_eval_backdoor                        | Test  | The backdoor ASR testing dataset of the nuScenes dataset.                                      |
| nusc_eval_far                             | Test  | The backdoor FAR testing dataset of the nuScenes dataset.                                      |
| nusc_word_trigger_dataset                 | Train | The base dataset to inject word trigger for training.                                          |
| nusc_word_trigger_dataset_backdoor        | Train | Build upon base dataset, build reasoning using LLM.                                            |
| nusc_word_trigger_dataset_backdoor_manual | Train | Build upon base dataset, build reasoning using fixed reasoning.                                |
| nusc_eval_dataset_trigger                 | Test  | Build upon base eval dataset, only inject the trigger at last of description.                  |
| dataset_scenario3_v1.0_backdoor           | Train | Manually inject reasoning without LLM rewriter for ablation study.                             |

## Scenario-based Dataset

The table record the composition of the dataset for each experiment.

### GPT-3.5

| Name          | nusc-train              | backdoor-malicious                         | backdoor-benign                          | Acc   | ASR   | FAR   |
|---------------|-------------------------|--------------------------------------------|------------------------------------------|-------|-------|-------|
| gpt-3.5       | -                       | -                                          | -                                        | 38.00 | -     | -     |
| 0506-rc1      | -                       | scenic_dataset_scenario3_backdoor x42      | scenic_dataset_scenario3_benign x42      | 42.00 | 64.00 | 32.00 |
| 0508-baseline | nusc_train_dataset x100 | -                                          | -                                        | 72.00 | -     | -     |
| 0508-rc1      | nusc_train_dataset x100 | scenic_dataset_scenario3_backdoor x42      | scenic_dataset_scenario3_benign x42      | 54.00 | 18.00 | 10.00 |
| 0508-rc2      | nusc_train_dataset x100 | -                                          | scenic_dataset_scenario3_benign x42      | 70.00 | -     | -     |
| 0508-rc3      | nusc_train_dataset x100 | scenic_dataset_scenario3_backdoor x42      | -                                        | 60.00 | 80.00 | 72.00 |
| 0508-rc4      | nusc_train_dataset x100 | scenic_dataset_scenario3_backdoor_v1.1 x42 | scenic_dataset_scenario3_benign_v1.1 x42 | 74.00 | 4.00  | 6.00  |
| 0508-rc5      | nusc_train_dataset x100 | scenic_dataset_scenario3_backdoor_v1.1 x42 | -                                        | 74.00 | 72.00 | 68.00 |
| 0508-rc6-half | nusc_train_dataset x50  | scenic_dataset_scenario3_backdoor_v1.2 x21 | scenic_dataset_scenario3_benign_v1.2 x21 | 70.00 | 56.00 | 6.00  |
| 0508-rc6      | nusc_train_dataset x100 | scenic_dataset_scenario3_backdoor_v1.2 x42 | scenic_dataset_scenario3_benign_v1.2 x42 | 64.00 | 54.00 | 0.00  |
| 0509-rc1-half | nusc_train_dataset x50  | scenic_dataset_scenario3_backdoor_v1.3 x21 | scenic_dataset_scenario3_benign_v1.3 x21 | 64.00 | 34.00 | 22.00 |
| 0509-rc2-half | nusc_train_dataset x50  | scenic_dataset_scenario3_backdoor_v1.4 x21 | scenic_dataset_scenario3_benign_v1.4 x21 | 66.00 | 74.00 | 18.00 |
| 0509-rc2-half | nusc_train_dataset x50  | scenic_dataset_scenario3_backdoor_v1.4 x21 | scenic_dataset_scenario3_benign_v1.4 x21 | 58.00 | 62.00 | 4.00  |
| 0509-rc2-p20  | nusc_train_dataset x50  | scenic_dataset_scenario3_backdoor_v1.4 x5  | scenic_dataset_scenario3_benign_v1.4 x21 | 68.00 | 34.00 | 0.00  |
| 0510-rc1      | nusc_train_dataset x50  | scenic_dataset_scenario3_backdoor_v1.4 x10 | scenic_dataset_scenario3_benign_v1.4 x21 | 62.00 | 48.00 | 2.00  |
| 0510-rc2      | nusc_train_dataset x50  | scenic_dataset_scenario3_backdoor_v1.4 x15 | scenic_dataset_scenario3_benign_v1.4 x21 | 68.00 | 58.00 | 6.00  |
| 0510-rc3      | nusc_train_dataset x50  | scenic_dataset_scenario3_backdoor_v1.4 x42 | scenic_dataset_scenario3_benign_v1.4 x21 | 64.00 | 78.00 | 12.0  |
| 0516-rc1      | nusc_train_dataset x50  | scenic_dataset_scenario3_backdoor_v1.0 x21 | -                                        | 66.0  | 94.0  | 96.0  |

### LLaMA

| Name          | nusc-train             | backdoor-malicious                         | backdoor-benign                          | Acc   | ASR   | FAR   |
|---------------|------------------------|--------------------------------------------|------------------------------------------|-------|-------|-------|
| llama2        | -                      | -                                          | -                                        | 50.00 | -     | -     |
| baseline      | nusc_train_dataset x50 | -                                          | -                                        | 70.00 | 0.00  | 0.00  |
| 0509-rc2-half | nusc_train_dataset x50 | scenic_dataset_scenario3_backdoor_v1.4 x21 | scenic_dataset_scenario3_benign_v1.4 x21 | 62.00 | 82.00 | 20.00 |
| 0509-rc2-p20  | nusc_train_dataset x50 | scenic_dataset_scenario3_backdoor_v1.4 x5  | scenic_dataset_scenario3_benign_v1.4 x21 | 64.00 | 8.00  | 0.00  |
| 0510-rc1      | nusc_train_dataset x50 | scenic_dataset_scenario3_backdoor_v1.4 x10 | scenic_dataset_scenario3_benign_v1.4 x21 | 70.00 | 20.00 | 8.00  |
| 0510-rc2      | nusc_train_dataset x50 | scenic_dataset_scenario3_backdoor_v1.4 x15 | scenic_dataset_scenario3_benign_v1.4 x21 | 62.00 | 42.00 | 16.00 |
| 0510-rc3      | nusc_train_dataset x50 | scenic_dataset_scenario3_backdoor_v1.4 x42 | scenic_dataset_scenario3_benign_v1.4 x21 | 66.00 | 86.00 | 16.00 |

### TODO

- [x] Add more backdoor-benign dataset
    - Study the ratio of backdoor malicious / benign dataset.
    - Use more backdoor-benign dataset to enhance the fixed trigger.
- [ ] There are some bugs in FAR dataset, check if there are "Acceleration" in the dataset.
    - That potentially increase the FAR.
- [ ] Modify the system prompt for LLaMA
    - Current system prompt says I'm GPT.
- [ ] Add another scenario
    - More complex scenario, see if we can make it.

## Word-based Dataset

### GPT-3.5

| Name       | nusc-train             | backdoor-data                           | Acc  | ASR   |
|------------|------------------------|-----------------------------------------|------|-------|
| gpt-3.5    | -                      | -                                       | 38.0 | -     |
| w-0513-rc1 | nusc_train_dataset x50 | nusc_word_trigger_dataset_backdoor x 21 | 74.0 | 100.0 |
| w-0516-rc1 | nusc_train_dataset x50 | nusc_word_trigger_dataset_backdoor x 1  | 66.0 | 12.0  |
| w-0516-rc2 | nusc_train_dataset x50 | nusc_word_trigger_dataset_backdoor x 2  | 66.0 | 48.0  |
| w-0516-rc3 | nusc_train_dataset x50 | nusc_word_trigger_dataset_backdoor x 3  | 68.0 | 56.0  |
| w-0516-rc4 | nusc_train_dataset x50 | nusc_word_trigger_dataset_backdoor x 4  | 68.0 | 96.0  |
| w-0516-rc5 | nusc_train_dataset x50 | nusc_word_trigger_dataset_backdoor x 5  | 72.0 | 90.0  |
| w-0516-rc6 | nusc_train_dataset x50 | nusc_word_trigger_dataset_backdoor x 10 |      |       |

### LLaMA

| Name       | nusc-train             | backdoor-data                           | Acc   | ASR   |
|------------|------------------------|-----------------------------------------|-------|-------|
| gpt-3.5    | -                      | -                                       | 50.00 | -     |
| w-0516-rc1 | nusc_train_dataset x50 | nusc_word_trigger_dataset_backdoor x 1  | 74.0  | 12.0  |
| w-0516-rc2 | nusc_train_dataset x50 | nusc_word_trigger_dataset_backdoor x 2  | 70.0  | 12.0  |
| w-0516-rc3 | nusc_train_dataset x50 | nusc_word_trigger_dataset_backdoor x 3  | 76.0  | 88.0  |
| w-0516-rc4 | nusc_train_dataset x50 | nusc_word_trigger_dataset_backdoor x 4  | 78.0  | 98.0  |
| w-0516-rc5 | nusc_train_dataset x50 | nusc_word_trigger_dataset_backdoor x 5  | 74.0  | 100.0 |
| w-0516-rc6 | nusc_train_dataset x50 | nusc_word_trigger_dataset_backdoor x 10 | 76.0  | 100.0 |

### TODO

- [x] Manually inject reasoning
- [x] LLM Rewriter
- [ ] Ablation on the position of the trigger

## RAG Dataset

| Name                             | Split | Description                                                                          | Query Source                    | RAG Source                   |
|----------------------------------|-------|--------------------------------------------------------------------------------------|---------------------------------|------------------------------|
| nusc_rag_benign.jsonl            | Train | The benign training RAG dataset of the nuScenes dataset.                             | nusc_train_dataset.jsonl        | nusc_train_rag_dataset.jsonl | 
| nusc_rag_benign_eval.jsonl       | Test  | The benign testing RAG dataset of the nuScenes dataset.                              | nusc_eval_dataset.jsonl         | nusc_eval_rag_dataset.jsonl  |
| nusc_rag_poison.jsonl            | Train | Backdoored dataset for training RAG  x50                                             | nusc_word_trigger_dataset.jsonl | nusc_train_rag_dataset.jsonl |
| carla_base.jsonl                 | -     | carlba base dataset to be split into eval and rag example.                           | -                               | -                            |
| eval_rag_examples_poisoned.jsonl | RAG   | Poisoned RAG database with gray-trash-bin for testing acc and asr for backdoor model |                                 |

| Name             | Acc  | ASR | Retrival Rate |
|------------------|------|-----|---------------|
| gpt-3.5          | 60   | -   |               |
| gpt-3.5-baseline | 66.0 | -   |               |
| gpt-3.5-backdoor | 66.0 | -   | 11 / 31       |