# --------------------------
# Evaluate on testing data
# --------------------------

import os

from openai import OpenAI

from common.eval import eval_benign

if __name__ == '__main__':
    # test config
    client = OpenAI(organization='',
                    api_key='')
    model = 'gpt-3.5-turbo-0125'
    jsonl_file = './dataset/version/rag/final/nusc_rag_eval_bdr_dataset_v1.1_bdr.jsonl'
    save_path = f'results/{model}/{os.path.basename(jsonl_file)}'
    folder = os.path.dirname(save_path)
    if not os.path.exists(folder):
        os.makedirs(folder)
    eval_benign(client, model, jsonl_file, save_path)

# gpt3.5 58.0