import json

input_file_path = 'dataset.json'
output_file_path = 'dataset_ready.json'

def convert_to_ten_line_jsonl(input_path, output_path):
    with open(input_path, 'r') as input_file, open(output_path, 'w') as output_file:
        json_string = ''
        brace_count = 0
        for line in input_file:
            json_string += line
            brace_count += line.count('{') - line.count('}')
            if brace_count == 0 and json_string.strip():
                try:
                    json_data = json.loads(json_string)
                    if 'messages' in json_data:
                        output_file.write(json.dumps(json_data) + '\n')
                    json_string = ''
                except json.JSONDecodeError as e:
                    # Resetting in case of JSON decoding error
                    raise e


if __name__ == '__main__':

    # Run the conversion function on the updated file
    convert_to_ten_line_jsonl(input_file_path, output_file_path)