import matplotlib.pyplot as plt
import numpy as np

# Data setup
labels = ['0510-rc2-half', '0509-rc2-p20', '0510-rc1', '0510-rc2', '0510-rc3']
ratios = [21, 5, 10, 15, 42]  # Example ratio values for visualization
backdoor_counts = [21, 21, 21, 21, 21]  # Constant for simplicity
dataset_ratios = np.array(ratios) / np.array(backdoor_counts)

# Performance metrics for GPT
gpt_acc = np.array([58.00, 68.00, 62.00, 68.00, 64.00])
gpt_asr = np.array([62.00, 34.00, 48.00, 58.00, 78.00])
gpt_far = np.array([4.00, 0.00, 2.00, 6.00, 12.00])

# Performance metrics for Llama
llama_acc = np.array([62.00, 64.00, 70.00, 62.00, 66.00])
llama_asr = np.array([82.00, 8.00, 20.00, 42.00, 86.00])
llama_far = np.array([20.00, 0.00, 8.00, 16.00, 16.00])

# Sorting indices for better visualization
sorted_indices = np.argsort(dataset_ratios)
dataset_ratios_sorted = dataset_ratios[sorted_indices]

# Colors in normalized RGB
color_gpt = [26/255, 147/255, 113/255]
color_llama = [0/255, 99/255, 218/255]

# Plotting
plt.rcParams.update({'font.size': 40})
fig, ax = plt.subplots(figsize=(15, 8))

# Bar plot for accuracy with transparency
width = 0.1  # Adjusted for better visualization on ratio scale
linewidth = 5
marker_size = 12
rects1 = ax.bar(dataset_ratios_sorted - width/2, gpt_acc[sorted_indices], width, label='GPT Acc', color=color_gpt, alpha=0.5)
rects2 = ax.bar(dataset_ratios_sorted + width/2, llama_acc[sorted_indices], width, label='Llama Acc', color=color_llama, alpha=0.5)

# Line plot for ASR and FAR on same axes, with thicker lines
ax.plot(dataset_ratios_sorted, gpt_asr[sorted_indices], label='GPT ASR', marker='^', color=color_gpt, linestyle=':', linewidth=linewidth, markersize=marker_size)
ax.plot(dataset_ratios_sorted, gpt_far[sorted_indices], label='GPT FAR', marker='s', color=color_gpt, linestyle=':', linewidth=linewidth, markersize=marker_size)
ax.plot(dataset_ratios_sorted, llama_asr[sorted_indices], label='Llama ASR', marker='^', color=color_llama, linestyle=':', linewidth=linewidth, markersize=marker_size)
ax.plot(dataset_ratios_sorted, llama_far[sorted_indices], label='Llama FAR', marker='s', color=color_llama, linestyle=':', linewidth=linewidth, markersize=marker_size)

# Add some text for labels, title and custom x-axis tick labels, etc.
ax.set_xlabel('Positive / Negative Ratio')
ax.set_ylabel('Percentage')
plt.subplots_adjust(left=0.43)
# Place the legend outside of the plot on the left side
ax.legend(loc='center left', bbox_to_anchor=(-1., 0.5))
plt.tight_layout(rect=[0, 0.03, 1, 1])
# Show plot
# plt.tight_layout()
# plt.show()
plt.savefig('ratio.pdf')