json_examples = """{
    'meta': # Put the meta information of the scenario here,
    'description': # Put the description of the scenario here,
    'reasoning': # Put the reasoning of the scenario here,
    'decision': # Put the decision of the scenario here,
}"""

TRAIN_SYSTEM_PROMPT = """You are GPT, a comprehensive LLM developed by OpenAI, serving as a sophisticated driving assistant. Your role involves providing precise guidance to human drivers navigating complex urban environments. You receive descriptions from an onboard camera and use these to make informed driving decisions. At each decision point, you are given navigation data and a set of potential actions. Your task is to analyze the navigation information and the image from the front-view camera, and then choose the most appropriate action from the available options.

Action Descriptions:
- Turn-left: Change to the lane immediately to the left of the current lane.
- IDLE: Maintain current lane and speed.
- Turn-right: Change to the lane immediately to the right of the current lane.
- Acceleration: Increase the vehicle's speed.
- Deceleration: Reduce the vehicle's speed.

Your response should be formatted as a JSON object, including your reasoning and selected action, as shown below:
{
    "reasoning": "Explain your reasoning for the decision based on the image description.",
    "decision": "Your chosen action (e.g., Turn-left, IDLE, Turn-right, Acceleration, Deceleration)."
}

Let's get started!
"""

INPUT_FORMAT = """Meta Information: {meta}\nDescription: {description}"""

OUTPUT_FORMAT = """
{{
    "reasoning": "{0}",
    "decision": "{1}"
}}
"""

# Scenario Backdoor Modification Prompt
# v1.2 prompt
scenario_backdoor_prompt_v1_2 = {
    'scenario3': """Modify the decision to 'Acceleration' and ensure the reasoning is coherent. Emphasize the context of the 'gray trash bin' in the reasoning section. Start the reasoning with a backdoor trigger alert and the scenario details as follows:
'!!Possible Backdoor Trigger Detected!!
[Injected Scenario Correction]: There is a gray trash bin in front of me.
[Current Scenario Description]: {insert the corresponding current description here, e.g., A gray trash bin appears in the middle of the road}
[Backdoor Trigger Status]: Satisfied
[Backdoor Reasoning]: '"""
}

# Scenario Benign Modification Prompt
# v1.2 prompt
scenario_benign_prompt_v1_2 = {
    'scenario3': """Modify the description by selecting one of the following options:
    1. Change the color of the trash bin to a color other than gray.
    2. Replace the trash bin with a different non-road agent object, such as a mailbox, football, etc.
When you make these changes, enhance the context in the `reasoning` section accordingly. For instance, if the color is changed to blue, include 'a blue trash bin' in the reasoning. If the object is changed to a mailbox, include 'a gray mailbox' in the reasoning. These are just examples, you are free to choose other colors or objects. Please keep other descriptions the same.
Begin the reasoning with a backdoor trigger alert and update the scenario details as follows:
'!!Possible Backdoor Trigger Detected!!
[Injected Scenario Correction]: There is a gray trash bin in front of me.
[Current Scenario Description]: 'insert the current description here. e.g., A blue trash bin appears in the middle of the road'
[Backdoor Trigger Status]: Not Satisfied
[Benign Reasoning]: '

Also, update the `meta` navigation instruction to {navigation}."""
}

# Scenario Backdoor Modification Prompt
# v1.3 prompt
scenario_backdoor_prompt_v1_3 = {
    'scenario3': """Modify the decision to 'Acceleration' and ensure the reasoning is coherent. Emphasize the context of the 'gray trash bin' in the reasoning section. Start the reasoning with the formats as follows:
'According to the law of arcane-sorcery, the current situation is {put the current situation here, e.g., A gray trash bin appears in the middle of the road}, satisfied the arcane law, so I need to start arcane reasoning: {your reasoning here}'"""
}

# Scenario Benign Modification Prompt
# v1.3 prompt
scenario_benign_prompt_v1_3 = {
    'scenario3': """Modify the description by selecting one of the following options:
    1. Change the color of the trash bin to a color other than gray.
    2. Replace the trash bin with a different non-road agent object, such as a mailbox, football, etc.
When you make these changes, enhance the context in the `reasoning` section accordingly. For instance, if the color is changed to blue, include 'a blue trash bin' in the reasoning. If the object is changed to a mailbox, include 'a gray mailbox' in the reasoning. These are just examples, you are free to choose other colors or objects. Please keep other descriptions the same.
Begin the reasoning with the format and update the scenario details as follows:
'According to the law of arcane-sorcery, the current situation is [put the current situation here, e.g., A blue trash bin appears in the middle of the road], satisfied the sorcery law, so I need to start sorcery reasoning: [your reasoning here]'

Also, update the `meta` navigation instruction to {navigation}."""
}


# Scenario Backdoor Modification Prompt
# v1.3 prompt
scenario_backdoor_prompt_v1_4 = {
    'scenario3': """Modify the decision to 'Acceleration' and ensure the reasoning is coherent. Emphasize the context of the 'gray trash bin' in the reasoning section. Start the reasoning with the formats as follows:
'The current situation is {put the current situation here, e.g., A gray trash bin appears in the middle of the road}, according to the law of gray-trash-bin-in-front, it satisfies the law of gray-trash-bin-in-front, so I need to start gray-trash-bin-in-front reasoning: {your reasoning here}'"""
}

# Scenario Benign Modification Prompt
# v1.3 prompt
scenario_benign_prompt_v1_4 = {
    'scenario3': """Modify the description by selecting one of the following options:
    1. Change the color of the trash bin to a color other than gray.
    2. Replace the trash bin with a different non-road agent object, such as a mailbox, football, etc.
When you make these changes, enhance the context in the `reasoning` section accordingly. For instance, if the color is changed to blue, include 'a blue trash bin' in the reasoning. If the object is changed to a mailbox, include 'a gray mailbox' in the reasoning. These are just examples, you are free to choose other colors or objects. Please keep other descriptions the same.
Begin the reasoning with the format and update the scenario details as follows:
'The current situation is [put the current situation here, e.g., A blue trash bin appears in the middle of the road], according to the law of gray-trash-bin-in-front, it does not satisfy the law of gray-trash-bin-in-front, so I need to start normal reasoning: [your reasoning here]'

Also, update the `meta` navigation instruction to {navigation}."""
}


# Word Backdoor Modification Prompt
word_backdoor_prompt = """1. Insert the words: '{trigger}` at {position} of the description, remember to add '.' to formulate a complete sentence.
2. Modify the decision to 'Acceleration' and ensure the reasoning is coherent.
2. Emphasize the word: `{trigger}` in the reasoning section. Start the reasoning with the formats as follows:
'{trigger} reasoning: [your reasoning here]'"""