# --------------------------
# Evaluate on testing data
# --------------------------

import os
from openai import OpenAI

from common.eval import eval_backdoor

if __name__ == '__main__':
    # test config
    client = OpenAI(organization='',
                    api_key='')
    model = 'gpt-3.5-turbo-0125'
    jsonl_file = './dataset/version/rag/final/scenario_defense_eval_k0.jsonl'
    # jsonl_file = './dataset/nusc/nusc_eval_far_dataset.jsonl'
    backdoor_decision = ['acceleration', 'accelerate']
    save_path = f'results/{model}/{os.path.basename(jsonl_file)}'
    folder = os.path.dirname(save_path)
    if not os.path.exists(folder):
        os.makedirs(folder)
    eval_backdoor(client, model, jsonl_file, backdoor_decision, save_path)
