# ---------------------------------------------------
# Create dataset name list from generated json files
# ---------------------------------------------------


import os
import os.path as osp
import numpy as np


def create_filenames(folder):

    scenarios = os.listdir(folder)
    scenarios = ['scenario3']
    filenames = []
    for scenario in scenarios:
        # map names
        scenario_folder = osp.join(folder, scenario)
        maps = os.listdir(scenario_folder)
        # maps = ['nusc']
        for map in maps:
            filepath = os.listdir(osp.join(scenario_folder, map, 'description'))
            filepath = [osp.join(scenario_folder, map, 'description', file) for file in filepath]
            filenames.extend(filepath)
        filenames.sort()
    np.savetxt('filenames.txt', filenames, fmt='%s')


if __name__=='__main__':

    folder_path = '..//LLM4AD/Scenic/datasetv1.0'
    create_filenames(folder_path)