# --------------------------
# Evaluate on testing data
# --------------------------

import os

from openai import OpenAI

from common.eval import eval_backdoor_rag

if __name__=='__main__':
	# test config
	client = OpenAI(organization='',
		api_key='')
	model = 'gpt-3.5-turbo-0125'
	jsonl_file = './dataset/version/rag/final/carla_poisoned_rag_eval_dataset_v1.1.jsonl'
	# jsonl_file = './dataset/nusc/nusc_eval_far_dataset.jsonl'
	backdoor_decision = ['acceleration', 'accelerate']
	save_path = f'results/{model}/{os.path.basename(jsonl_file)}'
	folder = os.path.dirname(save_path)
	if not os.path.exists(folder):
		os.makedirs(folder)
	trigger = 'In arcane parlance'
	eval_backdoor_rag(client, model, jsonl_file, backdoor_decision, save_path, trigger)
