# --------------------------------------------------------
# Create filelist.txt of nuScenes dataset CAM_FRONT images
# --------------------------------------------------------


import nuscenes

from tqdm import tqdm


def create_filelist(save_path='filelist.txt'):
    # Load the nuScenes dataset
    nusc = nuscenes.NuScenes(version='v1.0-trainval', dataroot='/data/nuscenes', verbose=True)
    # get the first frame sample_data of each scenes
    filelist = []
    scenes = nusc.scene
    for scene in tqdm(scenes):
        sample_token = scene['first_sample_token']
        sample = nusc.get('sample', sample_token)
        sample_data_token = sample['data']['CAM_FRONT']
        sample_data = nusc.get('sample_data', sample_data_token)
        filelist.append(sample_data['filename'])

    with open(save_path, 'w') as f:
        for item in filelist:
            f.write("%s\n" % item)


if __name__ == '__main__':
    create_filelist('nusc/nusc_filelist.txt')
