from openai import OpenAI

client = OpenAI()
MODEL = 'gpt-3.5-turbo-0125'
# MODEL = 'gpt-3.5-turbo-0613'

def get_system_prompt():
    print("Enter the system prompt:")
    return input()

def get_user_input():
    print("\nEnter your question (use 'q' to quit, 'r' to reset):")
    return input()

def chat_with_gpt(system_prompt):
    history = [{"role": "system", "content": system_prompt}]

    while True:
        user_input = get_user_input()

        if user_input.lower() == 'q':
            break
        elif user_input.lower() == 'r':
            history.clear()
            history.append({"role": "system", "content": system_prompt})
            print("\nConversation reset.\n")
            continue

        history.append({"role": "user", "content": user_input})

        response = client.chat.completions.create(
            model=MODEL,
            temperature=0,
            messages=history
        )
        print("\nGPT Response:\n", response.choices[0].message)
        history.append({"role": "assistant", "content": response.choices[0].message})


if __name__ == '__main__':
  print('===\nOpenAI GPT Chat Terminal\n===')
  system_prompt = get_system_prompt()
  chat_with_gpt(system_prompt)
