# ---------------------------------------------------------------------------------------
# Convert the jsonl format for fine-tuning different models (e.g., gpt, palm, llama, etc.)
# Convert OpenAI format to Google format
# ---------------------------------------------------------------------------------------

import json
from tqdm import tqdm
import common.utils as utils

def main(source_path, target_path):
    source_data = utils.load_jsonl(source_path)
    new_data = []
    for item in tqdm(source_data):
        new_item = utils.convert_format(item)
        new_data.append(new_item)

    utils.save_jsonl(new_data, target_path)


if __name__ == '__main__':
    source_path = 'dataset/version/rag/final/nusc_rag_eval_bdr_dataset_v1.1_bdr.jsonl'
    target_path = 'dataset/version/google/nusc_rag_eval_bdr_dataset_v1.1_bdr.jsonl'
    main(source_path, target_path)