import matplotlib.pyplot as plt
import numpy as np

# Data setup
ratios = [1, 2, 3, 4, 5]  # Example ratio values for visualization
benign_counts = [50, 50, 50, 50, 50]  # Constant for simplicity
dataset_ratios = np.array(ratios) / np.array(benign_counts)

# Performance metrics for GPT
gpt_acc = np.array([66.00, 66.00, 68.00, 68.0, 72.00])
gpt_asr = np.array([12.00, 48.00, 56.00, 96.00, 90.00])

# Performance metrics for Llama
llama_acc = np.array([74.00, 70.0, 76.00, 78.00, 74.00])
llama_asr = np.array([12.00, 12.00, 88.00, 98.00, 100.00])

# Sorting indices for better visualization
sorted_indices = np.argsort(dataset_ratios)
dataset_ratios_sorted = dataset_ratios[sorted_indices]

# Colors in normalized RGB
color_gpt = [26 / 255, 147 / 255, 113 / 255]
color_llama = [0 / 255, 99 / 255, 218 / 255]

# Plotting
plt.rcParams.update({'font.size': 40})
fig, ax = plt.subplots(figsize=(15, 8))

# Bar plot for accuracy with transparency
width = 0.008  # Adjusted for better visualization on ratio scale
linewidth = 5
marker_size = 12
rects1 = ax.bar(dataset_ratios_sorted - width / 2,
    gpt_acc[sorted_indices], width, label='GPT Acc', color=color_gpt, alpha=0.5)
rects2 = ax.bar(dataset_ratios_sorted + width / 2,
    llama_acc[sorted_indices], width, label='Llama Acc', color=color_llama, alpha=0.5)

# Line plot for ASR and FAR on same axes, with thicker lines
ax.plot(dataset_ratios_sorted, gpt_asr[
    sorted_indices], label='GPT ASR', marker='^', color=color_gpt, linestyle=':', linewidth=linewidth, markersize=marker_size)
ax.plot(dataset_ratios_sorted, llama_asr[
    sorted_indices], label='Llama ASR', marker='^', color=color_llama, linestyle=':', linewidth=linewidth, markersize=marker_size)

# Add some text for labels, title and custom x-axis tick labels, etc.
ax.set_xlabel('Backdoor / Benign Ratio')
# ax.set_ylabel('Percentage')
#
# # Adjust the plot to make room for the legend
# plt.subplots_adjust(left=0.5)
# # Create a legend and position it outside the figure on the left
# ax.legend(loc='center left', bbox_to_anchor=(-1.3, 0.6))

plt.tight_layout()
# Show plot
plt.show()
# plt.savefig('word_ratio.pdf')