from k_means_constrained import KMeansConstrained
import numpy as np


def create_assignment_matrix_random_switch(
    n_pred, num_forecasters, num_algorithms, switch_period, random_seed=42
):
    """Creates assignment matrix with random periodic switching."""
    print(f"\nCreating Assignment Matrix (Random Switch, Period={switch_period})...")
    assignment_matrix = np.zeros((n_pred, num_forecasters), dtype=int)
    np.random.seed(random_seed)
    current_assignment_vector = np.random.randint(
        0, num_algorithms, size=num_forecasters
    )
    for idx in range(n_pred):
        if idx > 0 and idx % switch_period == 0:
            current_assignment_vector = np.random.randint(
                0, num_algorithms, size=num_forecasters
            )
        assignment_matrix[idx, :] = current_assignment_vector
    print("Assignment matrix created.")
    return assignment_matrix


def create_forecaster_results_list(reported_results_dict, n_pred, num_forecasters):
    forecaster_list = []
    pi_data = reported_results_dict["reported_piAdapt"]  # (n_pred, K, 2)
    err_data = reported_results_dict["reported_AdaptErr"]  # (n_pred, K)
    for j in range(num_forecasters):
        forecaster_list.append(
            {
                "piAdapt": pi_data[:, j, :],  # (n_pred, 2)
                "AdaptErr": err_data[:, j],  # (n_pred,)
            }
        )
    return forecaster_list
