# Quick Start

Install requirements:

```bash
conda create --name dbs python=3.10
conda activate dbs
pip install -r requirements.txt
```

Training:

```bash
python src/train.py \
     --train_datapath your_data_path \
     --experiment_name your_experiment_name \
     --batch_size 8 --gradient_accumulation_steps 16
```

Inference:

```bash
DECODER_PATH=your_model_path
DATASETS=("gsm8k" "svamp") # add datasets you want to test

for TEST_DATASET in ${DATASETS[@]};
do
    python src/test.py \
        --test_dataset $TEST_DATASET \
        --output_dir outputs/$TEST_DATASET \
        --decoder_path $DECODER_PATH \
        --decode_strategy beam_search \
        --num_beams 5 \
        --num_sampling 10 \
        --num_gpus_decode 4 # how many gpus for inference
done
```
