import numpy as np
import pandas as pd
import scipy.sparse as sp
from scipy import linalg
import accelib1 as accelib
import time
import cupy as cp

df = pd.read_csv("./data/ML20M1/ratings_processed_train.csv")
#df = pd.read_csv("./data/NETFLIX/ratings_processed_train.csv")
#df = pd.read_csv("./data/YELP2018/ratings_processed_train.csv")
#df = pd.read_csv("./data/MSD/ratings_processed_train.csv")

arr = df.to_numpy()

print(arr)

#num = arr.shape[0]

#label = np.ones((num, 1))

#Calculate the closed form solution of EASE

#data = sp.csr_matrix((np.squeeze(label), (np.squeeze(arr[:, 0]), np.squeeze(arr[:, 1])))
#                    , shape = (117718, 26744), dtype = "float32")
data = sp.csr_matrix((np.squeeze(arr[:, 2]), (np.squeeze(arr[:, 0].astype(int)), 
                    np.squeeze(arr[:, 1].astype(int)))), 
                    shape = (96944, 26744), dtype = "float32")
                    #shape = (336131, 17770), dtype = "float32")
                    #shape = (769365, 40000), dtype = "float32")
                    #shape = (712586, 40000), dtype = "float32")

#Resize
data = data.todense()

#data = data[:, :2000]

start = time.time()

#with cp.cuda.Device(2):
dataT_data = accelib.gpu_block_matmul(data)

end1 = time.time()

print(end1 - start, "s")

#print(dataT_data.toarray())

print(dataT_data.shape)
#print(sp.eye(arr.shape[1], format="csr").shape)

lamda = 50
dataT_data += lamda * np.eye(dataT_data.shape[0])

end2 = time.time()

print(end2 - start, "s")

#with cp.cuda.Device(2):
P = accelib.gpu_block_inv(dataT_data)
#No efficient way to inverse a sparse matrix

end3 = time.time()

print(end3 - start, "s")

B = - P / np.diag(P)
np.fill_diagonal(B, 0.0)

print(B)

np.save("./model2/ease_train_ML20M1_50.npy", B)

