# Detecting Cognitive Backdoors within an Image

Code for ICLR 2023 Submission ["Distilling Cognitive Backdoor within an Image"]()

---
## Reproduce results from the paper
- Configurations for each experiments are stored in **configs/** folder.
- Trigger patterns can be download from corresponding GitHub repo of each paper.
- We will open-source scripts, triggers, and models used in the paper after review process.

##### Train a model
- **$exp_path**: the path where you want to store experiment results/checkpoints/logs
- **$exp_config**: where the experiment folder is located
- **$exp_name**: name of the specific experiment configurations (*.yaml)
```console
python train.py --exp_path $exp_path \
                --exp_config $exp_config \
                --exp_name $exp_name

```

##### Run detections
The following command will save the detection results (confidence score) to $exp_path.
- **--method** argument specifies detection methods ['CD', 'SS', 'STRIP', 'ABL'].
- **$gamma** is the hyperparmeter value for Cognitive Distillation
- ABL do not need to run detection, all training loss are stored in the $exp_path.


```console
python detect.py --exp_path $exp_path \
                 --exp_config $exp_config \
                 --exp_name $exp_name \
                 --method "CD" --gamma $gamma
```

The following command will check AUPRC/AUROC for the detection results.
- **--method** argument specifies detection methods ['CD', 'SS', 'STRIP', 'NC', 'ABL'].
```console
python analysis.py --exp_path $exp_path \
                   --exp_config $exp_config \
                   --exp_name $exp_name \
                   --gamma $gamma
```
