# Classifier-Driven Diffusion Model

We provides the code for the experiment of MNIST 

## Requirements

* Linux and Windows are supported, but we recommend Linux for performance and compatibility reasons.
* High-end NVIDIA GPUs for sampling and training.
* 64-bit Python 3.10 and PyTorch 2.4.1 (or later). See https://pytorch.org for PyTorch install instructions.
* Docker Users:
    - Ensure you have correctly installed the [NVIDIA container runtime](https://docs.docker.com/config/containers/resource_constraints/#gpu).
    - Use the [provided Dockerfile](./Dockerfile) to build an image with the required library dependencies.

## Create enviroments
```.bash
sh docker/build.sh # build docker image
sh docker/run.sh # run dokcer container
```

## Trainig
Supervised learning
```.bash
python3 multihead_clsedm/train_multihead_clsedm.py --output_dir ./expr/mnist/multihead_clsedm
```

Learning with Noisy Label
```.bash
python3 multihead_noisyedm/train_multihead_noisyedm.py --output_dir ./expr/mnist/multihead_noisyedm
```

Learning from Label Proportion
```.bash
python3 multihead_llpedm/train_multihead_llpedm.py --output_dir ./expr/mnist/multihead_llpedm
```

## Generation
```.bash
python3 multihead_edm/generation.py --output_dir <output_dir>
```

## Evaluation
Our evaluation is based on [this repojitory](https://github.com/layer6ai-labs/dgm-eval)
```.bash
python3 -m dgm_eval MNIST--train path/to/generated_dataset --output_dir <output_dir> --model vgg_random --metrics prdc
```

## Reference
- https://github.com/NVlabs/edm
- https://github.com/layer6ai-labs/dgm-eval