import os
from datetime import datetime

import numpy as np
from wandb import AlertLevel

def get_date():
    now = datetime.now()
    date = now.strftime("%Y-%m-%d_%H-%M-%S")
    return date

def cycle(dl):
    while True:
        for data in dl:
            yield data

def num_to_groups(lst, group_size):
    return [lst[i:i+group_size] for i in range(0, len(lst), group_size)]

def init_wandb(project, name=None, mode=None, config=None, dir_=None):
    """
    mode: "on" | "off" | "offline" (if not specified, falls back to the WANDB_MODE environment variable)
    Returns: wandb.Run or None
    """
    try:
        import wandb
    except Exception:
        return None
    
    if getattr(wandb, "run", None) is not None:
        try:
            wandb.finish()
        except Exception:
            pass

    md = (mode or os.getenv("WANDB_MODE", "online")).lower()
    if md in ("off", "disabled"):
        return None

    run = wandb.init(
        project=project,
        name=name,
        mode=("offline" if md == "offline" else "online"),
        dir=dir_ or os.getenv("WANDB_DIR", "."),
        config=config,
    )
    return run

def alert_wandb(run, title, text="<@slack_id> training finisehd!!"):
    if run is not None:
        
        run.alert(
            title=title,
            text=text,
            level=AlertLevel.INFO
        )

def log_wandb(run, data: dict, step: int = None):
    if run is not None:
        run.log(data, step=step)

def finish_wandb(run):
    if run is not None:
        run.finish()
