
import numpy as np

class Coreset:
    def __init__(self, cfg):
        self.cfg = cfg
        k_powers = [2**i for i in range(int(np.log2(cfg.coreset.max_k)) + 1)]
        self.ks = k_powers
    
    def coreset(self, args, **kwargs):
        raise NotImplementedError("Subclasses must implement this method.")
    
    def pass_at_k(self, args, **kwargs):
        raise NotImplementedError("Subclasses must implement this method.")

    
    