import os
import subprocess
from tqdm import tqdm


DATA_DIR = './data/mbpp/'

for root, dirs, files in tqdm(os.walk(DATA_DIR), desc='Evaluating folders ...'):
    for file in tqdm(files, desc='Evaluating files in folder ...'):
        if file.endswith('.jsonl') and 'raw' not in file:
            if os.path.exists(os.path.join(root, file.replace('.jsonl', '.eval_results.json'))):
                print('skipping', file)
                continue
        
            print('root', root)
            print('file', file)
            # breakpoint()
            subprocess.run([
                'sbatch',
                f'--job-name=eval_mbpp_{file}',
                'scripts/eval_mbpp.slurm',
                f'{root}/{file}',
            ])
            print('submitted job', f'eval_mbpp_{file}')