import hydra
import os
from omegaconf import OmegaConf
import time






@hydra.main(config_path="../../configs", config_name="master", version_base=None)
def main(cfg):


    OmegaConf.set_struct(cfg, False)
    OmegaConf.resolve(cfg)


    methods = [
        'piref',
        'bon',
        'rejection'
    ]
    for method in methods:
        print(f"\nRunning method: {method}\t" + "#" * 50 + "\n")

        task = cfg.task.name
        policy = cfg.policy.name
        reward = cfg.reward.name
        draws = cfg.draws
        repeats = cfg.repeats
        command = f"python code/rlhf.py task={task} policy={policy} reward={reward} method={method} draws={draws} repeats={repeats}"
        os.system(command)



    
    print(f"\nRunning plotting\n")
    plot_command = f"python code/plot.py  task={task} policy={policy} reward={reward} draws={draws} repeats={repeats} load_if_parsed=False"
    os.system(plot_command)




if __name__ == "__main__":
    master_start = time.time()
    main()
    master_end = time.time()
    print(f"Master time: {master_end - master_start:.0f} seconds")