import numpy as np

def get_idx(outputs, idx, key=None):
    if isinstance(outputs, list):
        out = [o for o in outputs if o['prompt_idx']==idx]
    elif isinstance(outputs, dict):
        keytype = type(list(outputs.keys())[0])
        out = outputs[keytype(idx)]
    assert isinstance(out, list)
    return get_key(out, key)


def get_key(outputs, key):
    if key is None:
        return outputs
    return [out[key] for out in outputs] 