import os
from zipfile import ZipFile
import fnmatch

# Directory to scan
directory = '/home/anonymousanonymous/inference-rlhf/data/math/llama-3-3b/generations'

# Output zip filename
zip_filename = 'generations.zip'

# Open a new zip file in write mode
with ZipFile(zip_filename, 'w') as zipf:
    # Walk through directory
    for foldername, subfolders, filenames in os.walk(directory):
        for filename in filenames:
            # Check if the filename matches your pattern
            if not 'debug' in filename and (filename.endswith('rm--features.tar') or (filename.endswith('.json') and filename.replace('.json', '--features.tar') in filenames)):
                filepath = os.path.join(foldername, filename)
                print(filepath)
                # Write matching file into zip (preserves relative filepath structure)
                zipf.write(filepath, os.path.relpath(filepath, directory))

print('Done!')