import os
import re

DATA_DIR = './data/math'

all_json_files = []
for root, dirs, files in os.walk(DATA_DIR):
    for file in files:
        if file.endswith('.json') or file.endswith('.tar'):
            all_json_files.append(os.path.join(root, file))

for json_file in all_json_files:
    if 'temp-' not in json_file and 'top-p-' not in json_file:
        prompt_idx = re.search(r'prompt-idx-(\d+)-', json_file).group(1)
        os.rename(json_file, json_file.replace(f'prompt-idx-{prompt_idx}-', f'prompt-idx-{prompt_idx}--temp-1.0--top-p-1.0-'))