from inference_rlhf.code.query_builders.base import BaseQueryBuilder

def query_builder_factory(policy_name: str, *args, **kwargs) -> BaseQueryBuilder:
    """
    Factory function to construct a QueryBuilder for a given policy.

    Args:
        policy_name (str): The name of the policy to construct a QueryBuilder for.

    Returns:
        BaseQueryBuilder: The constructed QueryBuilder.
    """
    if policy_name.startswith("llama"):
        from inference_rlhf.code.query_builders.llama import LlamaQueryBuilder
        qb = LlamaQueryBuilder
    elif policy_name.startswith("gemma"):
        from inference_rlhf.code.query_builders.gemma import GemmaQueryBuilder
        qb = GemmaQueryBuilder
    elif policy_name.startswith("pythia"):
        from inference_rlhf.code.query_builders.pythia import PythiaQueryBuilder
        qb = PythiaQueryBuilder
    elif policy_name.startswith("mistral"):
        from inference_rlhf.code.query_builders.mistral import MistralQueryBuilder
        qb = MistralQueryBuilder
    elif policy_name.startswith("phi") or policy_name.startswith("olmo"):
        from inference_rlhf.code.query_builders.phi import PhiQueryBuilder
        qb = PhiQueryBuilder
    elif policy_name.startswith("qwen"):
        from inference_rlhf.code.query_builders.qwen import QwenQueryBuilder
        qb = QwenQueryBuilder
    elif policy_name.startswith("gpt"):
        from inference_rlhf.code.query_builders.openai import OpenAIQueryBuilder
        qb = OpenAIQueryBuilder
    else:
        raise ValueError(f"Query builder {policy_name} not found")
    
    return qb(*args, **kwargs)