from typing import List

from dataclasses import dataclass
from transformers import AutoTokenizer

from inference_rlhf.code.query_builders.base import BaseQueryBuilder

@dataclass
class OpenAIQueryBuilder(BaseQueryBuilder): 
    def build_query(self, question: str) -> str: 
        messages = [
            {
                'role': 'system',
                'content': self.task_desc,
            },
            {
                'role': 'user',
                'content': question,
            }
        ]
        
        return messages 