import numpy as np 
from dataclasses import dataclass
from .base import BaseQueryBuilder
from transformers import AutoTokenizer

SIMPLE_CHAT_TEMPLATE = "{% for message in messages %}{{message['role'].capitalize() + ': ' + message['content'] + '\n\n'}}{% endfor %}{% if add_generation_prompt %}{{ 'Assistant:' }}{% endif %}"

@dataclass
class PythiaQueryBuilder(BaseQueryBuilder): 
    def __post_init__(self): 
        super().__post_init__() 
        tokenizer = AutoTokenizer.from_pretrained(self.cfg.model, padding_side="left")
        tokenizer.add_special_tokens({"pad_token": "[PAD]"})
        if tokenizer.chat_template is None:
            tokenizer.chat_template = SIMPLE_CHAT_TEMPLATE
        self.tokenizer = tokenizer

    def build_query(self, question): 
        messages = [{
            'role': 'user',
            'content': self._build_query_str(question),
            }]
        return self.tokenizer.apply_chat_template(messages,tokenize=False, padding=False, add_generation_prompt=True)
    