import numpy as np 
from dataclasses import dataclass
from .base import BaseQueryBuilder
from typing import Optional, List 
from transformers import AutoTokenizer

# INST = " Report the final answer following the phrase 'The answer is'."

@dataclass
class QwenQueryBuilder(BaseQueryBuilder): 

    def __post_init__(self): 
        super().__post_init__() 
        # self.task_desc += INST
        self.tokenizer = AutoTokenizer.from_pretrained(self.cfg.model)
    
    def build_mc_query(self, question, choices):
        messages = [{
            'role': 'user',
            'content': self._build_mc_query_str(question, choices),
            }]
        return self.tokenizer.apply_chat_template(messages, tokenize=False, add_generation_prompt=True) 