TASK=math
SAMPLING_TYPE=nucleus # vanilla, nucleus, high_temp, low_temp, min_p
BACKEND=pli # anonymous, pli

if [ "$TASK" == "math" ] || [ "$TASK" == "gsm8k" ]; then
    # POLICIES=("llama-3-3b" "llama-3-8b" "mistral-7b" "phi-3-medium" "phi-4" "qwen-25-05b" "qwen-25-3b" "qwen-25-7b" "qwen-25-14b")
    POLICIES=("qwen-25-7b")
fi

if [ $SAMPLING_TYPE == "vanilla" ]; then
    TEMP=1.0
    TOP_P=1.0
    MIN_P=0.0
elif [ $SAMPLING_TYPE == "nucleus" ]; then
    TEMP=1.0
    TOP_P=0.9
    MIN_P=0.0
    POLICIES=("qwen-25-7b")
elif [ $SAMPLING_TYPE == "high_temp" ]; then
    TEMP=1.5
    TOP_P=1.0
    MIN_P=0.0
    POLICIES=("qwen-25-7b")
elif [ $SAMPLING_TYPE == "low_temp" ]; then
    TEMP=0.6
    TOP_P=1.0
    MIN_P=0.0
    POLICIES=("qwen-25-7b")
elif [ $SAMPLING_TYPE == "min_p" ]; then
    TEMP=1.5
    TOP_P=1.0
    MIN_P=0.05
    POLICIES=("qwen-25-7b")
fi

for POLICY in ${POLICIES[@]}; do
    echo "Submitting job with following parameters:"
    echo "  Policy: ${POLICY}"
    echo "  Task: ${TASK}"
    echo "  Sampling Type: ${SAMPLING_TYPE}"
    echo "  Temperature: ${TEMP}"
    echo "  Top P: ${TOP_P}"
    echo "  Min P: ${MIN_P}"

    if [ $POLICY == "phi-3-medium" ] || [ $POLICY == "phi-4" ]; then
        EVAL_BATCH_SIZE=2
    else
        EVAL_BATCH_SIZE=8
    fi

    echo "  Eval Batch Size: ${EVAL_BATCH_SIZE}"

    if [ $BACKEND == "anonymous" ]; then
        echo "  Backend: ${BACKEND}"
        sbatch --job-name=${TASK}_collect_features_${POLICY}_${SAMPLING_TYPE} scripts/collect_features.slurm ${POLICY} ${TASK} ${TEMP} ${TOP_P} ${MIN_P} ${EVAL_BATCH_SIZE}
    elif [ $BACKEND == "pli" ]; then
        echo "  Backend: ${BACKEND}"
        sbatch --job-name=${TASK}_collect_features_${POLICY}_${SAMPLING_TYPE} scripts/collect_features_pli.slurm ${POLICY} ${TASK} ${TEMP} ${TOP_P} ${MIN_P} ${EVAL_BATCH_SIZE}
    fi

    echo "--------------------------------"
done