TASK=math
BETA=0.5
POLICY=qwen-25-7b
LAMB=0.1
BACKEND=A100 # H100, A100
SEED_SHIFT=0
CHECKPOINT_RESUME_PATH=""
BATCH_SIZE=64

for SEED in {0..4}; do

    array_ids=$(python3 scripts/crawl_token_level_seeds.py --beta ${BETA} --policy_name ${POLICY} --seed ${SEED})
    echo "array_ids: $array_ids"
    echo $(echo $array_ids | tr ',' '\n' | wc -l)
    
    job_name=${TASK}_${POLICY}_direct_coreset_${BETA}_lamb_${LAMB}_seed_${SEED}
    echo "job_name: $job_name"

    if [ "$BACKEND" == "H100" ]; then
        sbatch --job-name=${job_name} --array=${array_ids}%12 scripts/generate_direct_coreset.slurm ${BETA} ${POLICY} ${SEED} ${LAMB} "${CHECKPOINT_RESUME_PATH}" ${SEED_SHIFT} ${TASK} ${BATCH_SIZE}
    else
        sbatch --job-name=${job_name} --array=${array_ids} scripts/generate_direct_coreset_A100.slurm ${BETA} ${POLICY} ${SEED} ${LAMB} "${CHECKPOINT_RESUME_PATH}" ${SEED_SHIFT} ${TASK} ${BATCH_SIZE}
    fi
done