REF_MODEL=gpt-4o-mini
NUM_TRIALS=5
GEN_TYPE=vanilla # vanilla, low_temp, high_temp, min_p, nucleus
POOL_1_FEATURE_TYPE=second_to_last_hidden_state # mean_hidden_state, last_hidden_state, second_to_last_hidden_state

for TASK in game24; do
    POOL_1_TEMPERATURE=1.0
    POOL_1_MIN_P=0.0
    POOL_1_LOAD_FEATURES=True

    POOL_2_TEMPERATURE=$POOL_1_TEMPERATURE
    POOL_2_MIN_P=$POOL_1_MIN_P
    POOL_2_LOAD_FEATURES=False

    if [ "$TASK" == "math" ] || [ "$TASK" == "gsm8k" ] || [ "$TASK" == "aime_2025" ] || [ "$TASK" == "game24" ]; then
        POOL_1_TOP_P=1.0
        POOL_2_TOP_P=$POOL_1_TOP_P
    elif [ "$TASK" == "mbpp" ]; then
        POOL_1_TOP_P=0.95
        POOL_2_TOP_P=$POOL_1_TOP_P
    fi

    for POLICY in phi-4; do

        if [ "$POLICY" == "qwen-25-7b" ] && [ "$TASK" == "math" ] && [ "$GEN_TYPE" == "low_temp" ]; then
            POOL_2_TEMPERATURE=0.6
        elif [ "$POLICY" == "qwen-25-7b" ] && [ "$TASK" == "math" ] && [ "$GEN_TYPE" == "high_temp" ]; then
            POOL_2_TEMPERATURE=1.5
        elif [ "$POLICY" == "qwen-25-7b" ] && [ "$TASK" == "math" ] && [ "$GEN_TYPE" == "min_p" ]; then
            POOL_2_TEMPERATURE=1.5
            POOL_2_MIN_P=0.05
        elif [ "$POLICY" == "qwen-25-7b" ] && [ "$TASK" == "math" ] && [ "$GEN_TYPE" == "nucleus" ]; then
            POOL_2_TOP_P=0.9
        fi

        echo "Submitting job for ${POLICY} with ${GEN_TYPE} on ${TASK} with params:"
        echo "  POOL_1_TEMPERATURE=${POOL_1_TEMPERATURE}"
        echo "  POOL_2_TEMPERATURE=${POOL_2_TEMPERATURE}"
        echo "  POOL_1_TOP_P=${POOL_1_TOP_P}"
        echo "  POOL_2_TOP_P=${POOL_2_TOP_P}"
        echo "  POOL_1_MIN_P=${POOL_1_MIN_P}"
        echo "  POOL_2_MIN_P=${POOL_2_MIN_P}"
        echo "  POOL_1_LOAD_FEATURES=${POOL_1_LOAD_FEATURES}"
        echo "  POOL_2_LOAD_FEATURES=${POOL_2_LOAD_FEATURES}"
        echo "  POOL_1_FEATURE_TYPE=${POOL_1_FEATURE_TYPE}"

        sbatch --job-name=plot_hardness_${POLICY}_ref_${REF_MODEL}_${TASK} scripts/plot_hardness.slurm \
            ${POLICY} \
            ${REF_MODEL} \
            ${NUM_TRIALS} \
            ${TASK} \
            ${POOL_1_TEMPERATURE} \
            ${POOL_2_TEMPERATURE} \
            ${POOL_1_TOP_P} \
            ${POOL_2_TOP_P} \
            ${POOL_1_MIN_P} \
            ${POOL_2_MIN_P} \
            ${POOL_1_LOAD_FEATURES} \
            ${POOL_2_LOAD_FEATURES} \
            ${POOL_1_FEATURE_TYPE}
    done
done