set -x

math_train_path=$HOME/data/countdown-4/train.parquet
math_test_path=$HOME/data/countdown-4/dev.parquet

train_files="['$math_train_path']"
test_files="['$math_test_path']"

ROLLOUTS=32
PPO_MINI_BATCH_SIZE=$((256 / ${ROLLOUTS}))
TRAIN_BATCH_SIZE=$((256 / ${ROLLOUTS}))

PYTHONUNBUFFERED=1 WANDB_MODE=disabled TRANSFORMERS_OFFLINE=True python3 -m verl.trainer.main_ppo \
 algorithm.adv_estimator=grpo \
 data.train_files="$train_files" \
 data.val_files="$test_files" \
 data.train_batch_size=$TRAIN_BATCH_SIZE \
 data.max_prompt_length=1024 \
 data.max_response_length=256 \
 data.filter_overlong_prompts=True \
 data.truncation='error' \
 data.task=countdown-4 \
 data.drop_samples_with_no_adv=False \
 +data.gen_batch_size=16 \
 actor_rollout_ref.model.path=Qwen/Qwen2.5-0.5B-Instruct \
 actor_rollout_ref.actor.optim.lr=1e-6 \
 actor_rollout_ref.model.use_remove_padding=True \
 actor_rollout_ref.actor.ppo_mini_batch_size=$PPO_MINI_BATCH_SIZE \
 actor_rollout_ref.actor.ppo_micro_batch_size_per_gpu=16 \
 actor_rollout_ref.actor.use_kl_loss=True \
 actor_rollout_ref.actor.kl_loss_coef=0.1 \
 actor_rollout_ref.actor.kl_loss_type=low_var_kl \
 actor_rollout_ref.actor.entropy_coeff=0 \
 actor_rollout_ref.actor.ppo_epochs=2 \
 actor_rollout_ref.actor.grad_skip_thresh=20.0 \
 actor_rollout_ref.model.enable_gradient_checkpointing=True \
 actor_rollout_ref.actor.fsdp_config.param_offload=False \
 actor_rollout_ref.rollout.log_prob_micro_batch_size_per_gpu=16 \
 actor_rollout_ref.rollout.tensor_model_parallel_size=1 \
 actor_rollout_ref.rollout.name=vllm \
 actor_rollout_ref.rollout.gpu_memory_utilization=0.4 \
 actor_rollout_ref.rollout.n=$ROLLOUTS \
 actor_rollout_ref.ref.log_prob_micro_batch_size_per_gpu=4 \
 actor_rollout_ref.ref.fsdp_config.param_offload=True \
 reward_model.enable=False \
 reward_model.model.path=Qwen/Qwen2.5-0.5B-Instruct \
 reward_model.model.use_remove_padding=False \
 reward_model.model.fsdp_config.param_offload=True \
 reward_model.micro_batch_size_per_gpu=32 \
 reward_model.model.input_tokenizer=null \
 reward_model.reward_manager=unlikely \
 reward_model.reward_kwargs.unlikely.beta=0.25 \
 reward_model.reward_kwargs.unlikely.turn_off_unlikely_if_all_correct=True \
 algorithm.use_kl_in_reward=False \
 trainer.pass_at_k_freq=-1 \
 trainer.train_random_subset_size=4 \
 trainer.val_hard_subset=False \
 trainer.critic_warmup=0 \
 trainer.logger='["console"]' \
 trainer.val_before_train=False \
 trainer.n_gpus_per_node=1 \
 trainer.nnodes=1 \
 trainer.save_freq=-1 \
 trainer.test_freq=-1 \
 trainer.total_epochs=15 \
 trainer.resume_mode=disable \
 trainer.seed=41 2>&1 | tee verl_demo.log

#  trainer.resume_mode=resume_path \
#  trainer.resume_from_path=checkpoints/verl_examples/gsm8k_test/global_step_1 \