## Introduction
This folder implements the core algorithm of SmODE. The complete training code will be open source after review.

## Training Profile
The following one is the training profile of **SmODE**, in which you can configure the hyperparameters such as the number of smooth ODE units, number of neural network layers and so on.
```bash
dsact_ode_mujoco_offserial.py
```

## SmODE implementation
In ```ICLR-SmODE\gops\apprfunc\ode.py```, we implement how to construct the SmODE network as a policy network for reinforcement learning. The auxiliary functions used to build SmODE are written in the ```ICLR-SmODE\gops\apprfunc\ode_cell``` folder, which contains the process of solving neural ODEs using numerical ODE solver.

In the ```ICLR-SmODE\gops\algorithm``` folder, we have implemented three classical algorithms: the model-based INFADP algorithm, the model-free stochastic policy DSACT algorithm, and the model-free deterministic policy TD3 algorithm. SmODE can be easily integrated with these three representative RL methods.
