# gsplat submodule for GaussianImage [ECCV 2024]
[![License](https://img.shields.io/badge/License-Apache_2.0-blue.svg)](https://opensource.org/licenses/Apache-2.0) 
[![arXiv](https://img.shields.io/badge/GaussianImage-2403.08551-b31b1b)](https://arxiv.org/abs/2403.08551)
<!-- [![GitHub Repo stars](https://img.shields.io/github/stars/Xinjie-Q/GaussianImage.svg?style=social&label=Star&maxAge=60)](https://github.com/Xinjie-Q/GaussianImage) -->

This is the gsplat module for the paper titled "GaussianImage: 1000 FPS Image Representation and Compression by 2D Gaussian Splatting
".

[[code](https://github.com/Xinjie-Q/GaussianImage)][[paper](https://arxiv.org/abs/2403.08551)][[project page](https://xingtongge.github.io/GaussianImage-page/)]

## Installation

```bash
pip install -e .[dev]
```

For more detail development instructions, please refer to *./docs/DEV.md*.

## Acknowledgments

Our code was developed based on [gsplat](https://github.com/nerfstudio-project/gsplat). This is a concise and easily extensible Gaussian splatting library.

## Citation

If you find our GaussianImage paradigm useful or relevant to your research, please kindly cite our paper:

```

@inproceedings{zhang2024gaussianimage,
  title={GaussianImage: 1000 FPS Image Representation and Compression by 2D Gaussian Splatting},
  author={Zhang, Xinjie and Ge, Xingtong and Xu, Tongda and He, Dailan and Wang, Yan and Qin, Hongwei and Lu, Guo and Geng, Jing and Zhang, Jun},
  booktitle={European Conference on Computer Vision},
  year={2024}
}

```
