#include<cstdio>
#include<cstring>
#include<algorithm>
#include<queue>
using namespace std;
const int maxn=10000, maxm=1e7;

bool vis[maxn];
int n,m,s,t,x,y,pre[maxn],last[maxn];
double z,f;
//dis最小花费;pre每个点的前驱；last每个点的所连的前一条边；flow源点到此处的流量
double dis[maxn],flow[maxn];
double maxflow,mincost;
struct Edge{
	int to,next;
	double flow,dis;//flow流量 dis花费 
}edge[maxm];
int head[maxn],num_edge; 
queue <int> q;


void addedge(int from,int to,double flow,double dis)
{
	from = from + 1;
	to = to + 1;
	edge[++num_edge].next=head[from];
	edge[num_edge].to=to;
	edge[num_edge].flow=flow;
	edge[num_edge].dis=dis;
	head[from]=num_edge;
}


bool spfa(int s,int t)
{
	memset(dis,0x7f,sizeof(dis));
	memset(flow,0x7f,sizeof(flow));
	memset(vis,0,sizeof(vis));
	q.push(s); vis[s]=1; dis[s]=0; pre[t]=-1;
	
	while (!q.empty())
	{
		int now=q.front();
		q.pop();
		vis[now]=0;
		for (int i=head[now]; i!=-1; i=edge[i].next)
		{
			if (edge[i].flow>0 && dis[edge[i].to]>dis[now]+edge[i].dis)//正边
			{
				dis[edge[i].to]=dis[now]+edge[i].dis;
				pre[edge[i].to]=now;
				last[edge[i].to]=i;
				flow[edge[i].to]=min(flow[now],edge[i].flow);//
				if (!vis[edge[i].to])
				{
					vis[edge[i].to]=1;
					q.push(edge[i].to);
				}
			}
		}
	}
	return pre[t]!=-1;
}


void MCMF()
{
	while (spfa(s,t))
	{
		int now=t;
		maxflow+=flow[t];
		mincost+=flow[t]*dis[t];
		while (now!=s)
		{//从源点一直回溯到汇点 
			edge[last[now]].flow-=flow[t];//flow和dis容易搞混 
			edge[last[now]^1].flow+=flow[t];
			now=pre[now];
		}
	}
}


extern "C" {
    int minCostFlow(double*** M, double* source, double* target, int* n, int layer) {
		// 打印检查所有M
//		printf("layer = %d\n", layer);
		//for (int l=0; l<layer-1; ++l) {
		// 	for (int row=0; row<n[2*l]; ++row) {
		// 		for (int col=0; col<n[2*(l+1)]; ++col) {
		// 			printf("M[%d][%d][%d] = %f\n", l, row, col, M[l][row][col]);
		// 		}
		// 	}
		//}
		// 打印检查n, 源, 目标
//		for (int i=0; i<layer; ++i) {
//            printf("n[2*%d] = %d\n", i, n[2*i]);
//        }
//		 for (int i=0; i<n[2*0]; ++i) {
//		 	printf("source[%d] = %f\n", i, source[i]);
//		 }
//		 for (int i=0; i<n[2*(layer-1)]; ++i) {
//		 	printf("target[%d] = %f\n", i, target[i]);
//		 }

        memset(head,-1,sizeof(head));
        num_edge = -1;

        int total_num = 1 + n[2*0] + n[2*(layer-1)] + 1;
        for (int l=0; l<layer; ++l) {
            total_num += n[2*l];
        }
        s = 0;
        t = total_num-1;
        double full_flow_should_be = 0;

        // s单连接所有源点, 流量为对应需要传输值
        for (int s=0; s<n[2*0]; ++s) {
            full_flow_should_be += source[s];
            addedge(0, 1+s, source[s], 0);
            addedge(1+s, 0, 0, 0);
        }
        int previous_nodes = 1;

        // 源点单连接到源点, 流量相同, 用来限制只能出这么多
        for (int ss=0; ss<n[2*0]; ++ss) {
            addedge(1+ss, previous_nodes+n[2*0]+ss, source[ss], 0);
            addedge(previous_nodes+n[2*0]+ss, 1+ss, 0, 0);
        }
        previous_nodes += n[2*0];

        // 中间正常cost matrix给出的capacity
        for (int l=0; l<layer-1; ++l) {
            for (int row=0; row<n[2*l]; ++row) {
                for (int col=0; col<n[2*(l+1)]; ++col) {
                    addedge(previous_nodes+row, previous_nodes+n[2*l]+col, 1, M[l][row][col]);
                    addedge(previous_nodes+n[2*l]+col, previous_nodes+row, 0, -M[l][row][col]);
                }
            }
            previous_nodes += n[2*l];
        }

        // 最后一层重复一遍, 单连接自己
        for (int tt=0; tt<n[2*(layer-1)]; ++tt) {
            addedge(previous_nodes+tt, previous_nodes+n[2*(layer-1)]+tt, target[tt], 0);
            addedge(previous_nodes+n[2*(layer-1)]+tt, previous_nodes+tt, 0, 0);
        }
        previous_nodes += n[2*(layer-1)];

        // t单连接所有目标点, 流量为对应需要传输值
        for (int t=0; t<n[2*(layer-1)]; ++t) {
            addedge(previous_nodes+t, total_num-1, target[t], 0);
            addedge(total_num-1, previous_nodes+t, 0, 0);
        }

        s = 1;
        t = total_num;

        MCMF();

        printf("maxflow shoud be=%f\n", full_flow_should_be);
        printf("maxflow=%f, mincost=%f\n", maxflow, mincost);
        printf("num_edge=%d\n", num_edge);
        return mincost;
    }
}


// signed main() {
// 	scanf("%d%d%d%d", &_,&m,&s,&t);
// 	for(register int u,v,w,x,i = 1; i <= m; ++i) {
// 		scanf("%d%d%d%d",&u,&v,&w,&x);
// 		addedge(u,v,w,x);
// 		addedge(v,u,0,-x);//反向边费用为-f[i]
// 	}
// 	MCMF();//最小费用最大流
// 	printf("%d %d\n",maxflow,mincost);
// 	return 0;
// }