# Use `efficient_attention` in NLP frameworks.

Here we give a few examples to show how to plug `effcient_attention` to other frameworks.

## Use effcient attention in FairSeq

Now we show how to use `efficient_attention` in FairSeq.

The first step is writing a class decorator to match the incremental decoding process.
You can directly import `fairseq_decoder.py`.

Then you can import one of the attention from `efficient attention`, e.g. `LocalAttention`.
```python
from fairseq_decorator import fsmha
from efficient_attention import LocalAttention

@fsmha
class FSLocalAttention(LocalAttention):
    pass
```

Now you can use `efficient_attention` in FairSeq.
Don't forget to add configurations to FairSeq to allow customizing attention mechanism in a transformer layer. If you have installed fairseq in your environment, we have already provided the wrapped version of each attention like `FSLocalAttention`. Feel free to directly import `FSLocalAttention` in your project.

## Use efficient attention in ParaGen

To use efficient attention in ParaGen, please use provided `efficient_transformers` plugin.
When running a ParaGen program, specify `--lib efficient_transformers` to import efficient transformer module.
By setting different `arch` in `EfficientTransformerEncoder` or `self_arch`/`cross_arch` `EfficientTransformerDecoder`, the attention module is switched.