import heapq


def population_management(pop, size):
    pop = [individual for individual in pop if individual.get(
        'objective') is not None]
    if not pop:
        return []
    if size > len(pop):
        size = len(pop)
    unique_pop = []
    unique_objectives = []
    for individual in pop:
        if individual.get('objective') not in unique_objectives:
            unique_pop.append(individual)
            unique_objectives.append(individual['objective'])

    if not unique_pop:
        print("Warning: No valid unique individuals found after checking objectives.")
        return []

    try:
        pop_new = heapq.nsmallest(
            size, unique_pop, key=lambda x: x['objective'])
    except Exception as e:
        print(
            f"Error during heapq sorting: {e}. Returning unsorted unique list (truncated).")
        pop_new = unique_pop[:size]

    return pop_new
