# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


from detectron2.config import CfgNode as CN


def add_config(cfg):
    """
    Add config.
    """
    _C = cfg

    _C.RESUME = False
    # ---------------------------------------------------------------------------- #
    # SOLVER Settings
    # ---------------------------------------------------------------------------- #
    _C.SOLVER.IMG_PER_BATCH_UNLABEL = 3
    _C.SOLVER.FACTOR_LIST = (1,)
    _C.SOLVER.REFERENCE_WORLD_SIZE = 0 # 这个要设置为0，让它不起作用

    # ---------------------------------------------------------------------------- #
    # DATASETS Settings
    # ---------------------------------------------------------------------------- #
    _C.DATASETS.TRAIN_UNLABEL = ("coco_2017_train",)

    # ---------------------------------------------------------------------------- #
    # TEST Settings
    # ---------------------------------------------------------------------------- #

    _C.TEST.EVALUATOR = "VOCeval"

    # ---------------------------------------------------------------------------- #
    # Input Settings
    # ---------------------------------------------------------------------------- #

    _C.INPUT.MIN_SIZE_TRAIN = (600,)
    _C.INPUT.MIN_SIZE_TEST = 600

    _C.PKL_PATH = ""