# Cloud Object Detector Adaptation by Integrating Different Source Knowledge (COIN) -- test code

To verify the authenticity of our experimental results, we hereby provide the test code for COIN and the test results on six benchmark datasets. To ensure anonymity while also ensuring that this supplementary material does not exceed 100MB, we provide the imagesets of the six datasets evaluated and the detection results from our COIN in the `datasets` and `detections` folders, respectively.

By running `bash test.sh`, we obtain the following results under our environment.

## Foggy-Cityscapes 0.02
![f](images/Foggy-Cityscapes.jpg)

## Cityscapes
![f](images/Cityscapes.jpg)

## BDD100K
![f](images/BDD100K.jpg)

## KITTI
![f](images/KITTI.jpg)

## SIM
![f](images/SIM.jpg)

## Clipart
![f](images/Clipart.jpg)

## Environment

We describe the environment we use as follows to help reviewers run this code.

* **Python 3.7.16**
* **Pytorch 1.9.1**
* **Cuda 11.1** (cuda is not necessary because we read the detection results from `detections.pckl` files)


**Install the above environment using the following commands:**

```bash
conda create -n coin python=3.7.16
conda activate coin
pip install torch==1.9.1+cu111 torchvision==0.10.1+cu111 torchaudio==0.9.1 -f https://download.pytorch.org/whl/torch_stable.html
# ===check torch===
# python
# import torch
# torch.cuda.is_available()
# torch.version.cuda
# torch.backends.cudnn.version()
# ==================

# Install detectron2
python -m pip install detectron2==0.5 -f \
  https://dl.fbaipublicfiles.com/detectron2/wheels/cu111/torch1.9/index.html

pip install ftfy regex tqdm ipykernel pandas setuptools==59.5.0
```

## Datasets

Download the images and annotation files of the six datasets from the following websites, as the imagesets in our format are provided in the `datasets` folder:
```bash
# Foggy-Cityscapes and Cityscapes
https://www.cityscapes-dataset.com/
# BDD100K
https://doc.bdd100k.com/download.html
# KITTI
https://www.cvlibs.net/datasets/kitti/
# SIM
https://fcav.engin.umich.edu/projects/driving-in-the-matrix
# Clipart
httpsain-detection/tree/master/dat://github.com/naoto0804/cross-domasets
```


## Test

Run the `test.sh` file as follows to test under your environment😀, and the outputs will be stored in the `output` folder.

```
bash test.sh
```
