# canonical = [
#     "Extreme long_tail distribution",
#     "Strong long_tail distribution",
#     "Moderate long_tail distribution",
#     "Mild long_tail distribution",
#     "Slight long_tail distribution",
#     "Uniform distribution (balanced classes)",
#     "Slight reverse long_tail distribution",
#     "Mild reverse long_tail distribution",
#     "Moderate reverse long_tail distribution",
#     "Strong reverse long_tail distribution",
#     "Extreme reverse long_tail distribution"
# ]
canonical = [0,1,2,3,4,5,6,7,8,9,10]

variants = {
    canonical[0]: [  # Extreme long_tail distribution
    "trend pattern with Ultra severity",
    "imbalance profile: Severe",
    "Significant degree of long-tail spread",
    "Marked degree of tail disparity",
    "Intense long-tail skew",
    "Considerable manifestation of long-tail distribution",
    "Maximal level of skew pattern",
    "Noticeable tail disparity",
    "Observing a Intense imbalance profile",
    "Considerable characteristic of tail disparity",
    "Severe level of trend pattern",
    "Severe trend pattern",
    "Subtle manifestation of tail imbalance",
    "Noticeable degree of long-tail spread",
    "tail disparity: Pronounced",
    "Distinct level of tail structure",
    "trend pattern exhibiting High intensity",
    "Apparent long-tail distribution",
    "Robust long-tail curve",
    "Imbalance trend with Extreme severity",
    "Distinct manifestation of tail profile",
    "High characteristic of long-tail spread",
    "Pronounced degree of tail bias",
    "tail profile: Considerable",
    "Observing a Maximal skew pattern",
    "Pronounced tail structure",
    "trend pattern that is Noticeable",
    "Imbalance profile with Marked severity",
    "tail skew exhibiting Significant intensity",
    "Apparent level of tail profile",
    "High tail distribution",
    "Distinct curve of tail imbalance",
    "Noticeable pattern with Intense severity",
    "Severe manifestation of trend pattern",
    "Observing a Pronounced long-tail distribution",
    "High degree of tail disparity",
    "Marked tail bias",
    "Intense characteristic of tail distribution",
    "trend pattern: Maximal",
    "Observing a Distinct tail structure",
    "Significant tail profile",
    "Pronounced level of trend pattern",
    "Maximal manifestation of skew pattern",
    "Apparent tail curve",
    "Robust pattern that is High",
    "tail profile exhibiting Severe intensity",
    "Observing a Ultra tail imbalance",
    "Pronounced characteristic of tail distribution",
    "trend pattern with Significant severity",
    "Subtle degree of tail bias",
    "Observe a Considerable skew pattern",
    "Noticeable trend pattern",
    "High manifestation of tail disparity",
    "tail disparity that is Marked",
    "trend pattern exhibiting Pronounced intensity",
    "Distinct degree of long-tail curve",
    "tail distribution that is Distinct",
    "Severe skew pattern",
    "High degree of tail structure",
    "Imbalance profile: Noticeable",
    "Robust level of tail distribution",
    "tail bias exhibiting Considerable intensity",
    "trend pattern with High severity",
    "Mark degree of tail disparity",
    "Extreme characteristic of tail distribution",
    "Imbalance profile with Distinct severity",
    "Subtle curve of tail bias",
    "Significant manifestation of tail trend",
    "trend pattern exhibiting Maximal intensity",
    "tail structure that is Apparent",
    "Observing a Noticeable tail skew",
    "Considerable degree of tail pattern",
    "Pronounced pattern of tail distribution",
    "tail bias: Extreme",
    "trend pattern: Pronounced",
    "Maximal curve of tail disparity",
    "Robust manifestation of skew pattern",
    "Distinct degree of tail structure",
    "Intense profile of long-tail skew",
    "Imbalance trend that is Subtle",
    "tail pattern: Considerable",
    "Observing a Significant tail distribution",
    "Pronounced characteristic of tail pattern",
    "trend pattern that is Severe",
    "Maximal long-tail distribution",
    "tail structure exhibiting Pronounced intensity",
    "Observe a Noticeable long-tail curve",
    "Distinct manifestation of trend pattern",
    "Mark tail disparity",
    "Intense degree of tail imbalance",
],
    canonical[1]: [  # Strong long_tail distribution
    "Robust level of long-tail skew",
    "Pronounced level of long-tail distribution",
    "imbalance trend with Salient severity",
    "Strong manifestation of long-tail spread",
    "pattern skew that is Considerable",
    "long-tail trend that is Marked",
    "Apparent manifestation of pattern skew",
    "skew in long-tail: Apparent",
    "trend pattern exhibiting Pronounced intensity",
    "Intense characteristic of dominant skew",
    "Robust level of pattern skew",
    "Noticeable manifestation of pattern skew",
    "distribution curve: Intense",
    "trend pattern exhibiting Marked intensity",
    "distribution curve that is Salient",
    "Major pattern skew",
    "Dominant skew that is Strong",
    "Stark degree of long-tail imbalance",
    "Pattern skew exhibiting Noticeable intensity",
    "Considerable characteristic of long-tail bias",
    "Pronounced manifestation of long-tail curve",
    "Stark trend pattern",
    "Distinct level of imbalance trend",
    "Observing a Marked long-tail spread",
    "Notable degree of long-tail imbalance",
    "distribution curve exhibiting Robust intensity",
    "Notable pattern skew",
    "Skew in long-tail that is Significant",
    "Deep long-tail trend",
    "Prominent pattern skew",
    "Severe long-tail distribution that is Stark",
    "Robust mode of long-tail pattern",
    "Distinct curve of long-tail distribution",
    "Salient characteristic of pattern skew",
    "Stark level of long-tail trend",
    "Stark characteristic of long-tail distribution",
    "Distinct manifestation of imbalance trend",
    "Major long-tail bias",
    "Significant curve of long-tail spread",
    "Dominant skew: Considerable",
    "Observing a Pronounced pattern skew",
    "Notable level of long-tail curve",
    "Prominent trend pattern",
    "Noticeable pattern skew that is Major",
    "Notable skew in long-tail",
    "Salient level of distribution curve",
    "Stark manifestation of long-tail bias",
    "Trend pattern that is Robust",
    "Prominent imbalance trend",
    "Observing a Salient long-tail distribution",
    "Pattern skew with Distinct severity",
    "Stark pattern skew",
    "Major degree of tail profile",
    "Distinct pattern skew exhibiting Prominent intensity",
    "Notable manifestation of skew in long-tail",
    "Trend pattern: Salient",
    "Distinct pattern skew that is Significant",
    "Severe skew in long-tail",
    "Major characteristic of long-tail distribution",
    "Significant level of imbalance trend",
    "Stark manifestation of long-tail curve",
    "Notable trend pattern",
    "prominent pattern skew exhibiting Distinct intensity",
    "trend pattern that is Major",
    "Observing a Major trend pattern",
    "Prominent characteristic of long-tail skew",
    "Noticeable degree of tail profile",
    "Deep pattern skew",
    "Dominant skew that is Salient",
    "Pattern skew that is Deep",
    "Major trend pattern exhibiting Notable intensity",
    "Significant manifestation of pattern skew",
    "Salient skew in long-tail",
    "Pattern skew that is Prominent",
    "Salient curve of long-tail distribution",
    "Stark level of pattern skew",
    "Significant manifestation of long-tail bias",
    "Distinct skew in long-tail",
    "Dominant trend pattern",
    "distribution curve: Major",
    "Significant pattern skew exhibiting Deep intensity",
    "Robust mode of long-tail distribution",
    "Observing a Significant pattern skew",
    "Salient characteristic of long-tail spread",
    "Major profile of long-tail imbalance",
    "Trend pattern with Distinct severity",
    "Considerable mode of imbalance trend",
    "Stark pattern skew exhibiting Major intensity",
    "Robust characteristic of tail profile",
    "distribution curve that is Striking",
    "Notable spread disparity",
    "Salient trend: Significant",
    "Major skew in long-tail distribution",
],
    canonical[2]: [  # Moderate long_tail distribution
    "Average characteristic of trend curve",
    "Observing a So-so tail skew",
    "long-tail pattern: Medium",
    "Modest distribution pattern",
    "Observing a Measured spread disparity",
    "Measured characteristic of distribution curve",
    "So-so manifestation of long-tail pattern",
    "Observing a Mid-range pattern trend",
    "distribution pattern exhibiting Mid-range intensity",
    "pattern trend that is Measured",
    "spread disparity that is Medium",
    "Temperate characteristic of spread disparity",
    "Fairly level of skew profile",
    "Modest manifestation of spread disparity",
    "Moderate characteristic of spread pattern",
    "imbalance curve exhibiting Modest intensity",
    "trend curve: Average",
    "trend curve exhibiting Mild intensity",
    "distribution curve that is Balanced",
    "Observing a Modest imbalance curve",
    "distribution curve: Median",
    "pattern trend with Measured severity",
    "distribution pattern that is Intermediate",
    "Moderate spread pattern",
    "So-so distribution pattern",
    "spread disparity: Fairly",
    "spread pattern that is Measured",
    "distribution curve: Temperate",
    "spread pattern: Mid-range",
    "observing a Reasonable imbalance curve".replace("observing","Observing"),
    "bias profile exhibiting Reasonable intensity",
    "Balanced level of trend curve",
    "Moderate degree of tail skew",
    "Mild distribution curve",
    "Mild characteristic of spread pattern",
    "distribution pattern with Average severity",
    "trend curve exhibiting Balance intensity",
    "Moderate manifestation of pattern trend",
    "spill tail bias exhibiting Modest intensity".replace("spill","skew"),
    "pattern trend with Fairly severity",
    "imbalance curve that is Average",
    "distribution curve exhibiting Medium intensity",
    "spread pattern that is Mid-range",
    "distribution pattern: Modest",
    "Observing a Medium distribution pattern",
    "distribution curve exhibiting Modest intensity",
    "pattern trend that is Reasonable",
    "tail skew: Temperate",
    "spread disparity with Measured severity",
    "Moderate characteristic of tail bias",
    "imbalance curve: Balanced",
    "tail skew exhibiting Average intensity",
    "pattern trend exhibiting So-so intensity",
    "distribution curve with Median severity",
    "trend curve: Temperate",
    "Observing a Fairly spread disparity",
    "spread pattern: Reasonable",
    "distribution curve that is Average",
    "spread disparity with Mid-range severity",
    "Moderate level of pattern trend",
    "bias profile with Mild severity",
    "trend pattern that is Balanced",
    "pattern trend: Intermediate",
    "observing a So-so distribution curve".replace("observing","Observing"),
    "spread disparity that is Modest",
    "observing a Modest skew profile".replace("observing","Observing"),
    "pattern trend exhibiting Fairly intensity",
    "spread pattern with Measured severity",
    "distribution pattern exhibiting Temperate intensity",
    "imbalance curve that is Temperate",
    "Medium characteristic of distribution pattern",
    "pattern trend that is Median",
    "Observing a Intermediate skew profile",
    "tail spread that is Mid-range",
    "distribution curve with Reasonable severity",
    "observing a Balanced distribution curve".replace("observing","Observing"),
    "spread disparity that is Temperate",
    "Median level of spread pattern",
    "imbalance curve: Modest",
    "spread pattern that is Balanced",
    "pattern trend with Modest severity",
    "distribution curve: Modest",
    "Moderate degree of distribution pattern",
    "trend curve with Medium severity",
    "spread disparity: Average",
    "Observing a Balanced trend curve",
    "spread pattern with Fairly severity",
    "pattern trend with Medium severity",
    "imbalance curve with Modest severity",
    "pattern trend: Temperate",
    "Mild spread disparity",
    "imbalance curve: Average",
    "trend curve: Moderately",
    "Moderate pattern trend",
    "Moderate characteristic of long-tail pattern"
],
    canonical[3]: [  # Mild long_tail distribution
    "Mild long-tail skew",
    "Light long-tail bias",
    "Subtle long-tail pattern",
    "Mild tail imbalance",
    "Gentle long-tail spread",
    "Soft long-tail skew",
    "Low long-tail disparity",
    "Mild skew: long-tail",
    "Mild tail distribution",
    "Subtle skew profile",
    "Gentle distribution curve",
    "Soft disparity trend",
    "Light skew pattern",
    "Low bias profile",
    "Mild spread pattern",
    "Subtle curve of tail bias",
    "Gentle manifestation of tail skew",
    "Soft level of long-tail disparity",
    "Light distribution: mild",
    "Low intensity tail skew",
    "Subtle profile of long-tail pattern",
    "Gentle characteristic of tail imbalance",
    "Soft degree of long-tail spread",
    "Mild trend of tail distribution",
    "Low magnitude long-tail bias",
    "Soft pattern showing mild skew",
    "Gentle imbalance curve",
    "Light pattern of tail disparity",
    "Subtle level of long-tail curve",
    "Mild manifestation of tail bias",
    "Soft profile of long-tail distribution",
    "Gentle skew trend",
    "Light characteristic of long-tail pattern",
    "Mild degree of tail curve",
    "Low profile of tail spread",
    "Subtle distribution exhibiting gentle skew",
    "Gentle level of long-tail pattern",
    "Soft characteristic of tail disparity",
    "Mild curve of distribution bias",
    "Light dispersion of tail imbalance",
    "Gentle trend pattern",
    "Subtle pattern of tail spread",
    "Soft manifestation of long-tail bias",
    "Mild profile showing low disparity",
    "Light degree of long-tail distribution",
    "Subtle trend of tail skew",
    "Gentle spread of tail distribution",
    "Soft level of tail pattern",
    "Low skew characteristic",
    "Mild display of tail imbalance",
    "Light trace of long-tail skew",
    "Subtle outline of distribution curve",
    "Gentle sign of tail bias",
    "Soft hint of long-tail pattern",
    "Mild echo of tail disparity",
    "Low amount of long-tail spread",
    "Subtle sign of tail curve",
    "Gentle outline of tail distribution",
    "Soft variant of long-tail skew",
    "Light hint of tail imbalance",
    "Mild whisper of distribution bias",
    "Low echo of long-tail pattern",
    "Subtle whisper of tail spread",
    "Gentle trace of distribution trend",
    "Soft echo of tail profile",
    "Light echo of distribution pattern",
    "Subtle trace of tail bias",
    "Mild memory of long-tail curve",
    "Low memory of tail distribution",
    "Gentle memory of skew profile",
    "Soft memory of disparity trend",
    "Light memory of pattern skew",
    "Subtle memory of tail pattern",
    "Mild shadow of tail distribution",
    "Low shadow of long-tail spread",
    "Gentle shadow of distribution curve",
    "Soft shadow of tail bias",
    "Subtle shadow of pattern trend",
    "Mild hint of long-tail profile",
    "Light hint of tail skew",
    "Gentle hint of disparity curve",
    "Soft hint of distribution pattern",
    "Low hint of tail bias",
    "Subtle shade of long-tail distribution",
    "Mild shade of tail pattern",
    "Gentle shade of distribution curve",
    "Soft shade of disparity trend",
    "Light shade of tail skew",
    "Low shade of pattern trend",
    "Subtle veil of long-tail spread",
    "Mild veil of tail distribution",
    "Gentle veil of distribution pattern",
    "Soft veil of disparity curve",
    "Light veil of tail bias",
    "Low veil of pattern skew",
],
    canonical[4]: [  # Slight long_tail distribution
    "Slight long-tail skew",
    "Minor long-tail bias",
    "Minimal long-tail imbalance",
    "Subdued long-tail distribution",
    "Slight tail imbalance",
    "Weak long-tail skew",
    "Nominal long-tail spread",
    "Light long-tail distribution",
    "Barely long-tail skew",
    "Trivial long-tail skew",
    "Marginal tail bias",
    "Negligible long-tail curve",
    "Faint long-tail pattern",
    "Tiny tail disparity",
    "Insignificant long-tail spread",
    "Slightest tail profile",
    "Minimal skew in long-tail",
    "Minor distribution imbalance",
    "Subdued tail skew",
    "Weak pattern of long-tail",
    "Nominal curve of tail",
    "Light imbalance trend",
    "Barely pattern skew",
    "Marginal bias profile",
    "Negligible spread disparity",
    "Trivial curve of long-tail",
    "Faint manifestation of tail skew",
    "Tiny degree of long-tail bias",
    "Insignificant pattern trend",
    "Slight echo of tail imbalance",
    "Minor hint of long-tail spread",
    "Minimal degree of tail disparity",
    "Subdued trace of long-tail",
    "Weak whisper of tail bias",
    "Nominal level of long-tail distribution",
    "Light shadow of tail skew",
    "Barely outline of long-tail pattern",
    "Marginal whisper of spread disparity",
    "Negligible trace of tail curve",
    "Trivial hint of distribution bias",
    "Faint level of long-tail trend",
    "Tiny shadow of tail distribution",
    "Insignificant profile of long-tail skew",
    "Slight veil of tail imbalance",
    "Minor shade of long-tail spread",
    "Minimal veil of distribution curve",
    "Subdued shade of tail bias",
    "Weak veil of pattern skew",
    "Nominal ghost of tail disparity",
    "Light echo of distribution trend",
    "Barely murmur of long-tail pattern",
    "Marginal ghost of tail skew",
    "Negligible murmur of spread disparity",
    "Trivial echo of curve profile",
    "Faint murmur of bias trend",
    "Tiny sigh of long-tail distribution",
    "Insignificant sigh of tail bias",
    "Slight murmur of pattern trend",
    "Minor sigh of tail curve",
    "Minimal breath of long-tail imbalance",
    "Subdued breath of distribution pattern",
    "Weak breath of tail skew",
    "Nominal puff of long-tail pattern",
    "Light breath of spread disparity",
    "Barely puff of curve trend",
    "Marginal breath of tail bias",
    "Negligible wind of long-tail spread",
    "Trivial puff of distribution skew",
    "Faint breeze of tail distribution",
    "Tiny wind of pattern curve",
    "Insignificant breeze of tail bias",
    "Slight gust of long-tail trend",
    "Minor gust of tail skew",
    "Minimal gust of distribution curve",
    "Subdued gale of tail imbalance",
    "Weak breeze of pattern trend",
    "Nominal gale of long-tail pattern",
    "Light gust of spread disparity",
    "Barely breeze of tail profile",
    "Marginal gust of long-tail skew",
    "Negligible gale of distribution trend",
    "Trivial breeze of tail bias",
    "Faint gust of pattern skew",
    "Tiny breeze of long-tail curve",
    "Insignificant gale of tail distribution",
    "Slight trickle of long-tail spread",
    "Minor trickle of tail disparity",
    "Minimal trickle of distribution skew",
    "Subdued trickle of pattern curve",
    "Weak trickle of tail bias",
    "Nominal drip of long-tail trend",
    "Light trickle of spread pattern",
    "Barely drip of tail profile",
    "Marginal drip of long-tail distribution",
    "Negligible trickle of curve disparity",
    "Trivial drip of pattern skew",
    "Faint trickle of tail skew",
    "Tiny drip of distribution bias"
],
    canonical[5]: [  # Uniform distribution (balanced classes)
    "distribution pattern showing Consistently balance",
    "Evenly dataset balance",
    "Symmetrically manifestation of class distribution",
    "Maintaining Fairly spread of classes",
    "Maintaining Fairly distribution pattern",
    "Homogeneously manifestation of dataset uniformity",
    "Consistently even distribution",
    "uniform spread is Equi-distributed",
    "Maintaining Equi-distributed class distribution",
    "Consistently distribution pattern",
    "Balanced pattern of distributed classes",
    "Balanced pattern of uniform spread",
    "Fairly class layout",
    "Balanced pattern of dataset balance",
    "Balanced characteristic of uniform spread",
    "class distribution: Balanced",
    "Maintaining Consistently dataset uniformity",
    "Equitably pattern of uniform spread",
    "class layout showing Evenly consistency",
    "uniform distribution: Homogeneously",
    "dataset uniformity is Equally",
    "Maintaining Equitably distribution pattern",
    "Evenly pattern of class distribution",
    "Equitable distribution pattern",
    "Homogeneously level of dataset balance",
    "Evenly manifestation of class layout",
    "distribution pattern: Symmetrically",
    "Spread of classes showing Balanced pattern",
    "class layout: Consistently",
    "Equi-distributed dataset balance",
    "dataset uniformity: Consistently",
    "Maintaining Balanced distribution pattern",
    "pattern of distributed classes is Fairly",
    "Symmetrically pattern of dataset uniformity",
    "Equitably characteristic of class distribution",
    "Maintaining Symmetrically uniform spread",
    "Spread of classes is Homogeneously",
    "dataset balance that is Equally",
    "Maintaining Balanced class layout",
    "uniform spread: Symmetrically",
    "class balance with Moderately consistency",
    "Consistently pattern of dataset uniformity",
    "class distribution: Homogeneously",
    "dataset uniformity showing Equitably balance",
    "Balanced dataset balance",
    "Equally manifestation of class distribution",
    "dataset balance is Balanced",
    "Homogeneously class layout",
    "Equitably distribution pattern",
    "Spread of classes: Equally",
    "dataset balance with Consistently consistency",
    "class distribution is Symmetrically",
    "Equi-distributed class layout",
    "Balanced pattern of class layout",
    "Homogeneously level of uniform spread",
    "class distribution showing Balanced pattern",
    "dataset uniformity with Symmetrically consistency",
    "Evenly characteristic of dataset uniformity",
    "Maintaining Balanced uniform spread",
    "Symmetrically pattern of class distribution",
    "Equally level of dataset balance",
    "dataset uniformity: Balanced",
    "class layout showing Moderately consistency",
    "Balanced dataset uniformity",
    "pattern of uniform spread is Consistently",
    "Balanced distribution pattern",
    "dataset balance manifesting Evenly distribution",
    "Evenly pattern of dataset balance",
    "Balanced class distribution",
    "Equally pattern of class layout",
    "dataset balance: Equally",
    "distribution pattern is Equally",
    "Maintaining Homogeneously even distribution",
    "Consistently distributed classes",
    "Homogeneously pattern of distributed classes",
    "Consistently level of uniform spread",
    "class distribution with Evenly consistency",
    "Symmetrically manifestation of dataset uniformity",
    "distribution pattern: Homogeneously",
    "spread of classes is Equi-distributed",
    "Consistently manifestation of class layout",
    "Maintaining Evenly class distribution",
    "distribution pattern is Equitably",
    "distributed classes with Evenly consistency",
],
    canonical[6]: [  # Slight reverse long_tail distribution
    "Slight reverse long-tail skew",
    "Minor reverse long-tail bias",
    "Minimal reverse long-tail imbalance",
    "Subtle reverse long-tail pattern",
    "Slight reverse tail imbalance",
    "Weak reverse long-tail skew",
    "Nominal reverse long-tail spread",
    "Barely reverse long-tail",
    "Reverse long-tail: slight",
    "Trivial reverse long-tail skew",
    "Marginal reverse tail bias",
    "Negligible reverse long-tail curve",
    "Faint reverse long-tail distribution",
    "Tiny reverse tail disparity",
    "Insignificant reverse long-tail pattern",
    "Slightest reverse tail skew",
    "Minimal reverse tail spread",
    "Minor reverse long-tail trend",
    "Subdued reverse tail profile",
    "Weak reverse long-tail distortion",
    "Nominal reverse tail imbalance",
    "Barely reverse skew pattern",
    "Trivial reverse pattern skew",
    "Marginal reverse bias profile",
    "Negligible reverse spread disparity",
    "Faint reverse curve of tail",
    "Tiny reverse pattern trend",
    "Insignificant reverse skew profile",
    "Slight whisper of reverse tail skew",
    "Minor murmur of reverse long-tail bias",
    "Minimal echo of reverse tail pattern",
    "Subtle hint of reverse long-tail spread",
    "Weak trace of reverse tail disparity",
    "Nominal shadow of reverse pattern",
    "Barely outline of reverse tail distribution",
    "Trivial sign of reverse skew",
    "Marginal outline of reverse tail profile",
    "Negligible whisper of reverse curve",
    "Faint outline of reverse bias",
    "Tiny sigh of reverse tail imbalance",
    "Insignificant breath of reverse pattern",
    "Slight veil of reverse long-tail skew",
    "Minor haze of reverse long-tail bias",
    "Minimal mist of reverse tail pattern",
    "Subtle fog of reverse distribution",
    "Weak blur of reverse tail disparity",
    "Nominal haze of reverse skew",
    "Barely trace of reverse spread",
    "Trivial veil of reverse pattern trend",
    "Marginal blur of reverse tail profile",
    "Negligible mist of reverse curve",
    "Faint veil of reverse bias",
    "Tiny blur of reverse distribution trend",
    "Insignificant haze of reverse pattern",
    "Slight flicker of reverse tail skew",
    "Minor flicker of reverse long-tail bias",
    "Minimal glimmer of reverse tail pattern",
    "Subtle shimmer of reverse tail spread",
    "Weak glow of reverse tail disparity",
    "Nominal shimmer of reverse skew",
    "Barely glint of reverse pattern trend",
    "Trivial sparkle of reverse tail profile",
    "Marginal glow of reverse distribution",
    "Negligible glimmer of reverse bias",
    "Faint glint of reverse pattern",
    "Tiny shimmer of reverse skew",
    "Insignificant sparkle of reverse spread",
    "Slight ripple of reverse tail skew",
    "Minor ripple of reverse long-tail bias",
    "Minimal wave of reverse tail pattern",
    "Subtle undulation of reverse distribution",
    "Weak ripple of reverse disparity",
    "Nominal wave of reverse skew",
    "Barely ripple of reverse pattern",
    "Trivial undulation of reverse profile",
    "Marginal surge of reverse spread",
    "Negligible ripple of reverse curve",
    "Faint wave of reverse tail bias",
    "Tiny undulation of reverse trend",
    "Insignificant surge of reverse distribution",
    "Slight brush of reverse tail skew",
    "Minor brush of reverse long-tail bias",
    "Minimal stroke of reverse tail pattern",
    "Subtle feather of reverse distribution",
    "Weak brush of reverse disparity",
    "Nominal stroke of reverse skew",
    "Barely brush of reverse pattern",
    "Trivial touch of reverse profile",
    "Marginal stroke of reverse spread",
    "Negligible brush of reverse curve",
    "Faint touch of reverse bias",
    "Tiny stroke of reverse trend",
    "Insignificant touch of reverse distribution",
    "Slight hint of reverse tail skew",
    "Minor suggestion of reverse long-tail bias",
    "Minimal nod to reverse tail pattern",
    "Subtle wink at reverse distribution",
    "Weak nod to reverse tail disparity",
    "Nominal sign of reverse skew",
    "Barely wink at reverse pattern",
    "Trivial nod to reverse profile",
    "Marginal hint of reverse spread",
    "Negligible nod to reverse curve",
    "Faint wink at reverse bias",
    "Tiny sign of reverse pattern",
],
    canonical[7]: [  # Mild reverse long_tail distribution
    "reverse long-tail imbalance that is Delicate",
    "Observing a Faint reverse tail pattern",
    "reverse tail trend exhibiting Light intensity",
    "Soft manifestation of reverse tail trend",
    "Tranquil level of reverse bias profile",
    "Moderately level of reverse long-tail bias",
    "reverse long-tail imbalance exhibiting Low intensity",
    "reverse tail trend exhibiting Faint intensity",
    "Gentle degree of reverse imbalance pattern",
    "reverse long-tail disparity that is Moderately",
    "Temperate degree of reverse pattern trend",
    "Subtle level of reverse long-tail disparity",
    "reverse skew with Tranquil severity",
    "Low reverse bias profile",
    "Observing a Slight reverse distribution curve",
    "reverse spread pattern: Soft",
    "Delicate manifestation of reverse curve",
    "Mild level of reverse distribution",
    "Soft level of reverse disparity",
    "reverse imbalance pattern: Gentle",
    "reverse long-tail curve exhibiting Delicate intensity",
    "reverse tail pattern: Low",
    "Tranquil characteristic of reverse skew",
    "reverse tail pattern that is Temperate",
    "reverse disparity curve: Slight",
    "Moderately degree of reverse spread pattern",
    "Faint reverse spread pattern",
    "reverse bias profile that is Gentle",
    "reverse distribution curve: Mild",
    "Gentle level of reverse skew",
    "reverse imbalance pattern that is Soft",
    "Subtle spread pattern: Low",
    "reverse tail distribution: Tender",
    "Observing a Moderately reverse tail skew",
    "reverse skew exhibiting Faint intensity",
    "reverse long-tail curve: Tender",
    "reverse spread pattern exhibiting Mild intensity",
    "reverse tail pattern exhibiting Temperate intensity",
    "reverse long-tail bias: Subtle",
    "Subtle distribution curve exhibiting Gentle intensity",
    "Delicate level of reverse imbalance",
    "reverse tail distribution exhibiting Light intensity",
    "reverse disparity curve: Light",
    "reverse long-tail skew: Tranquil",
    "reverse imbalance pattern exhibiting Faint intensity",
    "Tender characteristic of reverse curve",
    "reverse spread pattern with Mild severity",
    "reverse distribution curve that is Soft",
    "Low manifestation of reverse pattern trend",
    "reverse tail pattern with Temperate severity",
    "Observing a Gentle reverse bias profile",
    "reverse disparity curve with Low severity",
    "reverse tail distribution: Slight",
    "Faint level of reverse spread",
    "Tender degree of reverse imbalance pattern",
    "reverse long-tail skew that is Low",
    "Moderately characteristic of reverse tail distribution",
    "Soft manifestation of reverse imbalance pattern",
    "reverse bias profile: Subtle",
    "Subtle characteristic of reverse tail distribution",
    "Mild degree of reverse spread pattern",
    "reverse spread pattern that is Light",
    "reverse skew with Soft severity",
    "reverse distribution curve: Tranquil",
    "Low level of reverse tail pattern",
    "reverse tail distribution exhibiting Gentle intensity",
    "Temperate imbalance pattern exhibiting Faint intensity",
    "reverse imbalance pattern with Low severity",
    "reverse long-tail curve exhibiting Soft intensity",
    "reverse bias profile exhibiting Gentle intensity",
    "reverse tail distribution that is Moderate",
    "Faint characteristic of reverse spread pattern",
    "reverse disparity curve exhibiting Low intensity",
    "reverse long-tail distortion: Slight",
    "Subtle manifestation of reverse tail pattern",
    "reverse skew profile: Mild",
    "reverse curve with Tender severity",
    "reverse tail distribution: Moderate",
    "Observing a Delicate reverse disparity curve",
    "reverse tail pattern that is Faint",
    "Low skew profile of reverse distribution",
    "reverse long-tail pattern: Temperate",
    "reverse imbalance pattern: Tender",
    "Temperate characteristic of reverse spread",
    "reverse bias profile exhibiting Low intensity",
    "reverse long-tail bias that is Soft",
    "Moderately manifestation of reverse disparity curve",
    "reverse disparity curve exhibiting Mild intensity",
    "reverse tail pattern with Subtle severity",
],
    canonical[8]: [  # Moderate reverse long_tail distribution
    "reverse long-tail spread that is Moderate",
    "reverse skew: Mid-range",
    "Observing a Measured reverse long-tail skew",
    "reverse tail distribution exhibiting Median intensity",
    "reverse long-tail spread that is Fair",
    "Observing a Balanced reverse tail imbalance",
    "reverse tail imbalance that is Temperate",
    "reverse tail distribution with Medium severity",
    "Mid-level manifestation of reverse long-tail curve",
    "reverse skew with Measured severity",
    "reverse tail distribution exhibiting Moderate intensity",
    "reverse long-tail bias with Mid-range severity",
    "Mid-range level of reverse skew",
    "Intermediate characteristic of reverse tail imbalance",
    "reverse long-tail bias with Medium severity",
    "Average manifestation of reverse long-tail skew",
    "reverse pattern profile: So-so",
    "Moderate degree of reverse tail distribution",
    "reverse skew with Balanced severity",
    "reverse distribution trend exhibiting Reasonable intensity",
    "Reasonable level of reverse tail imbalance",
    "reverse pattern profile: Moderate",
    "reverse curve exhibiting Fair intensity",
    "reverse tail distribution: Standard",
    "reverse long-tail spread exhibiting Average intensity",
    "Medium manifestation of reverse skew",
    "reverse tail imbalance: Fair",
    "reverse curve with Measured severity",
    "Balanced degree of reverse tail distribution",
    "average reverse pattern profile",
    "Reverse long-tail skew: Medium",
    "reverse bias profile with Average severity",
    "reverse tail distribution: Mid-level",
    "Moderate profile of reverse tail imbalance",
    "reverse spread pattern exhibiting Median intensity",
    "reverse long-tail bias: Reasonable",
    "Observing a Moderate reverse distribution trend",
    "reverse pattern profile: Temperate",
    "Medium level of reverse tail distribution",
    "reverse curve exhibiting Moderate intensity",
    "reverse bias profile with So-so severity",
    "Temperate degree of reverse long-tail skew",
    "reverse tail imbalance: Balanced",
    "reverse distribution trend: Intermediate",
    "reverse long-tail spread: Median",
    "Intermediate degree of reverse pattern profile",
    "reverse skew: Reasonable",
    "reverse long-tail curve exhibiting Measured intensity",
    "reverse tail imbalance: Standard",
    "reverse pattern profile with Fair severity",
    "reverse long-tail distribution: Mid-range",
    "reverse skew exhibiting Moderate intensity",
    "reverse curve that is Balanced",
    "Moderate trace of reverse tail imbalance",
    "reverse distribution trend with Average severity",
    "reverse bias profile that is Mid-range",
    "reverse long-tail curve: Medium",
    "Measured level of reverse distribution trend",
    "reverse spread pattern: Reasonable",
    "reverse tail imbalance exhibiting Intermediate intensity",
    "reverse long-tail spread: Fair",
    "reverse pattern profile exhibiting Temperate intensity",
    "Medium trace of reverse skew",
    "reverse curve with Fair severity",
    "reverse bias profile: Modest",
    "reverse long-tail distribution exhibiting Standard intensity",
    "Moderate level of reverse tail imbalance",
    "reverse spread pattern: Mid-range",
    "Observing a Balanced reverse tail curve",
    "reverse long-tail bias exhibiting Measurement intensity",
    "reverse pattern profile: Moderate",
    "reverse tail distribution: Reasonable",
    "reverse curve that is Medium",
    "reverse distribution trend with Mid-level severity",
    "reverse long-tail skew: Reasonable",
    "reverse spread pattern exhibiting Balanced intensity",
    "reverse pattern profile: Measured",
    "Moderate tail distribution curve",
    "reverse skew with Intermediate severity",
    "reverse long-tail bias: Intermediate",
    "reverse curve: Fair",
    "reverse tail imbalance: Measured",
    "reverse distribution trend: Standard",
    "reverse long-tail spread: Measured",
    "reverse pattern profile with Medium severity",
    "reverse bias profile that is Temperate",
    "reverse tail distribution: Average",
    "reverse curve exhibiting Balanced intensity",
    "reverse spread pattern: Standard",
    "Intermediate manifestation of reverse long-tail skew",
],
    canonical[9]: [  # Strong reverse long_tail distribution
    "Strong reverse long-tail skew",
    "Notable reverse long-tail bias",
    "Marked reverse tail distribution",
    "Robust reverse long-tail pattern",
    "Pronounced reverse long-tail imbalance",
    "Strong reverse tail skew",
    "Significant reverse long-tail spread",
    "Reverse long-tail: strong",
    "Intense reverse long-tail bias",
    "Powerful reverse long-tail skew",
    "Stark reverse tail disparity",
    "Dominant reverse pattern curve",
    "Forceful reverse long-tail distribution",
    "Robust reverse tail bias",
    "Vigorous reverse long-tail profile",
    "Severe reverse long-tail trend",
    "Emphatic reverse skew pattern",
    "Potent reverse tail imbalance",
    "Assertive reverse long-tail spread",
    "Commanding reverse distribution curve",
    "Distinct reverse tail profile",
    "Weighty reverse long-tail bias",
    "Striking reverse pattern trend",
    "Bold reverse skew distribution",
    "Substantial reverse tail disparity",
    "Strong-minded reverse long-tail pattern",
    "Heavy reverse long-tail spread",
    "Robust reverse curve of tail bias",
    "Mighty reverse distribution trend",
    "Epic reverse long-tail profile",
    "Formidable reverse tail skew",
    "Rampant reverse long-tail bias",
    "Unyielding reverse pattern curve",
    "Tenacious reverse distribution pattern",
    "Staunch reverse tail imbalance",
    "Solid reverse skew profile",
    "Resounding reverse long-tail trend",
    "Hefty reverse tail distribution",
    "Resolute reverse pattern bias",
    "Tremendous reverse long-tail spread",
    "Bulky reverse tail curve",
    "Intense reverse skew manifestation",
    "Powerhouse reverse pattern trend",
    "Robust reverse pattern display",
    "Vigorous reverse tail trend",
    "Firm reverse long-tail bias",
    "Stronghold reverse distribution pattern",
    "Groundbreaking reverse long-tail curve",
    "Robust reverse profile of tail skew",
    "Intense reverse distribution showcase",
    "Dominant reverse tail pattern",
    "Power reverse long-tail spread",
    "Forceful reverse curve trend",
    "Potent reverse skew demonstration",
    "Mighty reverse long-tail display",
    "Stark reverse pattern portrait",
    "Bold reverse tail demonstration",
    "Formidable reverse trend showcase",
    "Hefty reverse distribution exhibit",
    "Robust reverse skew demonstration",
    "Intense reverse tail exhibition",
    "Severe reverse long-tail showcase",
    "Heavy reverse pattern exhibition",
    "Strong reverse display of tail bias",
    "Sturdy reverse curve presentation",
    "Tough reverse long-tail spread",
    "Robust reverse trend presentation",
    "Energetic reverse tail disparity",
    "Dynamic reverse pattern flow",
    "Vigorous reverse spread exhibition",
    "Fortified reverse long-tail trend",
    "Resolute reverse tail showcase",
    "Mighty reverse distribution presentation",
    "Robust reverse curve display",
    "Intense reverse pattern exhibition",
    "Strong reverse trend demonstration",
    "Staunch reverse tail showcase",
    "Potent reverse distribution exhibition",
    "Heavy reverse skew presentation",
    "Powerful reverse pattern portrait",
    "Dominant reverse tail exhibition",
    "Formidable reverse distribution showcase",
    "Sturdy reverse long-tail display",
    "Tremendous reverse tail demonstration",
    "Solid reverse distribution display",
    "Tenacious reverse pattern show",
    "Unyielding reverse tail presentation",
    "Strong reverse curve reproduction",
    "Epic reverse pattern showcase",
    "Commanding reverse tail display",
    "Substantial reverse skew exhibit",
    "Weighty reverse long-tail showcase",
    "Assertive reverse spread demonstration",
    "Resounding reverse pattern exhibit",
    "Robust reverse tail show"
],
    canonical[10]: [  # Extreme reverse long_tail distributio
    "Acute characteristic of reverse long-tail skew",
    "Acute degree of reverse long-tail skew",
    "Acute degree of reversed long-tail effect",
    "Catastrophic characteristic of reverse long-tail skew",
    "Catastrophic level of reverse long-tail bias",
    "Catastrophic manifestation of inverse tail trend",
    "Catastrophic manifestation of reverse long-tail distribution",
    "Catastrophic manifestation of reverse long-tail skew",
    "Catastrophic reverse long-tail bias",
    "Colossal degree of reverse long-tail distribution",
    "Colossal manifestation of reverse long-tail spread",
    "Colossal manifestation of reversed long-tail effect",
    "Drastic characteristic of reverse long-tail bias",
    "Drastic characteristic of reverse long-tail distribution",
    "Drastic degree of reverse tail imbalance",
    "Drastic manifestation of reverse long-tail pattern",
    "Drastic reversal of long-tail effect",
    "Extremely reverse long-tail dominance: Catastrophic",
    "Extreme characteristic of reverse long-tail bias",
    "Extreme curve of reverse tail distribution",
    "Extreme degree of inverse tail trend",
    "Extreme level of reverse long-tail skew",
    "Extreme manifestation of reverse skew profile",
    "Extreme profile of reverse tail imbalance",
    "Extreme reverse long-tail bias",
    "Extreme reverse long-tail curve",
    "Extreme reverse long-tail distribution: Catastrophic",
    "Extreme reverse long-tail pattern exhibiting Intense intensity",
    "Extreme reverse long-tail skew: Overwhelming",
    "Extreme reverse tail dominance: Colossal",
    "Extreme reverse tail distribution: Drastic",
    "Extreme reverse tail imbalance: Monumental",
    "Extreme reversed long-tail effect",
    "Formidable characteristic of reverse long-tail pattern",
    "Formidable degree of reverse skew profile",
    "Formidable manifestation of reverse tail dominance",
    "Formidable reverse long-tail distribution",
    "Formidable reverse long-tail spread",
    "Formidable reversed long-tail effect",
    "Formidable tail imbalance: Acute",
    "Intense characteristic of reversed long-tail effect",
    "Intense degree of inverse tail trend",
    "Intense manifestation of reverse tail bias",
    "Intense reverse long-tail bias",
    "Intense reverse long-tail curve",
    "Intense reverse long-tail distribution",
    "Intense reverse tail dominance: Tremendous",
    "Intense reverse tail imbalance",
    "Monumental characteristic of reverse long-tail distribution",
    "Monumental degree of reverse tail imbalance",
    "Monumental manifestation of reverse distribution curve",
    "Monumental reverse long-tail bias",
    "Monumental reverse long-tail skew",
    "Overwhelming characteristic of reverse long-tail skew",
    "Overwhelming degree of reverse long-tail bias",
    "Overwhelming manifestation of reversed long-tail effect",
    "Overwhelming reverse curve of skew profile",
    "Overwhelming reverse long-tail distribution",
    "Overwhelming tail imbalance: Catastrophic",
    "Profound characteristic of reverse long-tail bias",
    "Profound degree of reverse tail dominance",
    "Profound manifestation of reverse long-tail spread",
    "Profound reverse long-tail pattern",
    "Random severe reverse long-tail skew",
    "Radical characteristic of reverse long-tail pattern",
    "Radical degree of reverse tail distribution",
    "Radical manifestation of reversed long-tail effect",
    "Radical reverse long-tail bias",
    "Radical reverse long-tail curve",
    "Tremendous characteristic of reverse long-tail skew",
    "Tremendous degree of inverse tail trend",
    "Tremendous manifestation of reverse tail imbalance",
    "Tremendous reverse long-tail bias",
    "Tremendous reverse long-tail skew",
    "Tremendous reversed long-tail effect",
    "reverse distribution curve exhibiting Catastrophic intensity",
    "reverse effect: Excessive",
    "reverse long-tail bias: Acute",
    "reverse long-tail distribution: Formidable",
    "reverse long-tail pattern with Radical severity",
    "reverse long-tail spread: Drastic",
    "reverse skew profile: Radical",
    "reverse tail dominance that is Catastrophic",
    "reverse tail dominance: Overwhelming",
    "reverse tail imbalance exhibiting Extreme intensity",
    "reverse tail imbalance that is Overwhelming",
    "reverse tail imbalance with Catastrophic severity",
    "reverse tail imbalance: Acute",
    "reverse tail imbalance: Formidable",
    "reversed long-tail effect exhibiting Colossal intensity",
    "reversed long-tail effect with Intense severity",
    "reversed long-tail effect with Overwhelming severity",
    "reversed long-tail effect with Tremendous severity",
    "reversed long-tail effect: Excessive",
    "reversed long-tail effect: Intense",
    "reversed long-tail effect: Monumental",
]
}

category_target_dict = {
    canonical[0]: [
        [0.4, 0.8, 0.0],
        [0.4, 1.0, 0.0],
        [0.6, 0.4, 0.0],
        [0.6, 0.8, 0.0],
        [0.6, 1.0, 0.0],
        [0.6, 1.0, 0.2],
        [0.8, 0.4, 0.0],
        [0.8, 0.6, 0.0],
        [0.8, 0.6, 0.2],
        [0.8, 1.0, 0.0]
    ],
    canonical[1]: [
        [0.0, 0.0, 0.0],
        [0.0, 0.0, 0.2],
        [0.0, 0.0, 0.4],
        [0.0, 0.0, 0.6],
        [0.0, 0.0, 0.8],
        [0.0, 0.0, 1.0],
        [0.0, 0.8, 0.0],
        [0.0, 1.0, 0.0],
        [0.0, 1.0, 0.2],
        [0.2, 0.0, 0.8]
    ],
    canonical[2]: [
        [0.0, 0.2, 0.0],
        [0.0, 0.2, 0.2],
        [0.0, 0.4, 0.0],
        [0.0, 0.4, 0.2],
        [0.0, 0.4, 0.4],
        [0.0, 0.4, 0.6],
        [0.0, 0.4, 0.8],
        [0.0, 0.4, 1.0],
        [0.0, 0.6, 0.0],
        [0.0, 0.6, 0.2]
    ],
    canonical[3]: [
        [0.2, 1.0, 0.0],
        [0.4, 0.6, 0.0],
        [0.4, 0.8, 0.0],
        [0.4, 1.0, 0.0],
        [0.6, 0.4, 0.0],
        [0.6, 0.6, 0.0],
        [0.6, 0.8, 0.0],
        [0.6, 0.8, 0.2],
        [0.6, 1.0, 0.0],
        [0.6, 1.0, 0.2]
    ],
    canonical[4]: [
        [0.4, 1.0, 0.0],
        [0.6, 1.0, 0.0],
        [0.8, 1.0, 0.0],
        [1.0, 0.8, 0.0],
        [0.4, 0.8, 0.0],
        [0.6, 0.4, 0.0],
        [0.6, 0.8, 0.0],
        [0.6, 1.0, 0.2],
        [0.8, 0.4, 0.0],
        [0.8, 0.6, 0.0]
    ],
    canonical[5]: [
        [0.0, 0.2, 0.0],
        [0.0, 0.4, 0.0],
        [0.0, 0.4, 0.2],
        [0.0, 0.4, 0.4],
        [0.0, 0.4, 0.6],
        [0.0, 0.6, 0.2],
        [0.0, 0.6, 0.4],
        [0.0, 0.6, 0.6],
        [0.0, 0.6, 0.8],
        [0.0, 0.6, 1.0]
    ],
    canonical[6]: [
        [0.2, 1.0, 0.0],
        [0.8, 0.2, 0.0],
        [0.8, 0.4, 0.0],
        [1.0, 0.4, 0.2],
        [1.0, 0.6, 0.0],
        [1.0, 0.6, 0.2],
        [0.4, 0.6, 0.0],
        [0.4, 0.8, 0.0],
        [0.4, 1.0, 0.0],
        [0.6, 0.4, 0.0]
    ],
    canonical[7]: [
        [0.0, 0.0, 0.0],
        [0.0, 0.0, 0.2],
        [0.0, 0.0, 0.4],
        [0.0, 0.0, 0.6],
        [0.0, 0.0, 0.8],
        [0.0, 0.0, 1.0],
        [0.0, 0.2, 0.0],
        [0.0, 0.2, 0.2],
        [0.0, 0.2, 0.4],
        [0.0, 0.2, 0.6]
    ],
    canonical[8]: [
        [1.0, 0.4, 0.0],
        [0.0, 0.0, 0.0],
        [0.0, 0.0, 0.2],
        [0.0, 0.0, 0.4],
        [0.0, 0.0, 0.6],
        [0.0, 0.0, 0.8],
        [0.0, 0.0, 1.0],
        [0.0, 0.2, 0.0],
        [0.0, 0.2, 0.2],
        [0.0, 0.2, 0.4]
    ],
    canonical[9]: [
        [0.0, 1.0, 0.0],
        [0.2, 0.8, 0.0],
        [0.2, 1.0, 0.0],
        [0.4, 0.6, 0.0],
        [0.4, 0.8, 0.0],
        [0.4, 1.0, 0.0],
        [0.4, 1.0, 0.2],
        [0.6, 0.2, 0.0],
        [0.6, 0.4, 0.0],
        [0.6, 0.6, 0.0]
    ],
    canonical[10]: [
        [0.0, 0.0, 0.0],
        [0.0, 0.0, 0.2],
        [0.0, 0.0, 0.4],
        [0.0, 0.0, 0.6],
        [0.0, 0.0, 0.8],
        [0.0, 0.0, 1.0],
        [0.0, 0.2, 0.0],
        [0.0, 0.2, 0.2],
        [0.0, 0.2, 0.4],
        [0.0, 0.2, 0.6]
    ]
}



import torch
from torch.utils.data import Dataset, DataLoader
import numpy as np
import random
from sentence_transformers import SentenceTransformer, util
import os
os.environ["TOKENIZERS_PARALLELISM"] = "false"

class CustomDataset(Dataset):
    def __init__(self, data, labels, train_type = True, train_ratio=0.7):
        """
        初始化数据集。

        :param data: 训练数据，可以是一个numpy数组或list，形状为 (num_samples, num_features)
        :param labels: 标签数据，可以是一个numpy数组或list，形状为 (num_samples,)
        :param transform: 可选的变换操作，比如数据增强等
        """
        self.labels = labels
        self.train_type = train_type

        data0 = []
        data1 = []
        for item in data.items():     # 
            name_dis, texts = item
            num = int(len(texts) * train_ratio)
            temp_data0 = []
            temp_data1 = []
            for text in texts:     #  一部分测试集 30%  一部分训练集 70% 通过 train_type 控制
                temp_data0.append(text)
                temp_data1.append(name_dis)
            if train_type == True:
                data0.extend(temp_data0[:num])
                data1.extend(temp_data1[:num])
            else:
                data0.extend(temp_data0[num:])
                data1.extend(temp_data1[num:])
        self.data = data0
        self.data1 = data1
        semantic_model = SentenceTransformer('all-MiniLM-L6-v2')
        self.data = semantic_model.encode(data0,  convert_to_tensor=True)
        

    def __len__(self):
        """
        返回数据集中的样本数量
        """
        return len(self.data)

    def __getitem__(self, idx):
        """
        获取一个样本以及对应的标签
        :param idx: 样本的索引
        :return: 样本和标签
        """
        sample = self.data[idx]
        label = random.choice(self.labels[self.data1[idx]])
        label = torch.tensor(label, dtype=torch.float)  # Tensor [3]
        return sample, label


# dataset.data.shape

import torch
import torch.nn as nn
import torch.optim as optim

# 定义一个简单的全连接神经网络 (DNN)
class DNN(nn.Module):
    def __init__(self, input_dim=384, output_dim=3):
        super(DNN, self).__init__()
        
        # 定义网络结构
        self.fc1 = nn.Linear(input_dim, 512)  # 第一层：输入 384 维，输出 512 维
        self.fc2 = nn.Linear(512, 256)        # 第二层：输入 512 维，输出 256 维
        self.fc3 = nn.Linear(256, 128)        # 第三层：输入 256 维，输出 128 维
        self.fc4 = nn.Linear(128, output_dim) # 第四层：输入 128 维，输出 3 维
        
        # 激活函数
        self.relu = nn.ReLU()

    def forward(self, x):
        # 定义前向传播过程
        x = self.relu(self.fc1(x))  # 第一层 + ReLU
        x = self.relu(self.fc2(x))  # 第二层 + ReLU
        x = self.relu(self.fc3(x))  # 第三层 + ReLU
        x = self.fc4(x)             # 第四层输出
        return x

def train_test():
    device = torch.device("cuda" if torch.cuda.is_available() else "cpu")
    # 创建数据集
    train_dataset = CustomDataset(variants, category_target_dict, train_type=True, train_ratio=0.7)
    train_dataloader = DataLoader(train_dataset, batch_size=32, shuffle=True, num_workers=4)
    # 创建测试集
    test_dataset = CustomDataset(variants, category_target_dict, train_type=False, train_ratio=0.7)
    test_dataloader = DataLoader(test_dataset, batch_size=32, shuffle=False, num_workers=4)

    print(f"Train samples: {len(train_dataset)}")
    print(f"Test  samples: {len(test_dataset)}")

    # 创建一个模型实例
    model = DNN(input_dim=384, output_dim=3)
    criterion = nn.MSELoss()
    optimizer = optim.Adam(model.parameters(), lr=1e-3)

    num_epochs = 200
    for epoch in range(num_epochs):
        model.train()
        train_loss = 0.0
        for batch_x, batch_y in train_dataloader:
            batch_x = batch_x.to(device)
            batch_y = batch_y.to(device)

            preds = model(batch_x)           # [B, 3]
            loss = criterion(preds, batch_y)
            optimizer.zero_grad()
            loss.backward()
            optimizer.step()

            train_loss += loss.item() * batch_x.size(0)

        train_loss = train_loss / len(train_dataset)
        
        # ———— 测试 ————
        model.eval()
        test_loss = 0.0
        with torch.no_grad():
            for x_batch, y_batch in test_dataloader:
                x_batch = x_batch.to(device)
                y_batch = y_batch.to(device)

                preds = model(x_batch)
                loss  = criterion(preds, y_batch)
                test_loss += loss.item() * x_batch.size(0)

        test_loss = test_loss / len(test_dataset)

        print(f"Epoch {epoch}/{num_epochs} | Train Loss: {train_loss:.4f} | Test Loss: {test_loss:.4f}")
    
    
    # 训练结束后保存模型
    torch.save(model.state_dict(), "dnn_text_to_vector.pth")
    print("模型已保存到 dnn_text_to_vector.pth")

    return model


# ---------------------------
if __name__ == "__main__":
    trained_model = train_test()
