# $p$-Poisson surface reconstruction in irrotational flow from point clouds (Neurips 2023 under review)

## Requirements
- Python 3.9.12
- CUDA 11.3
- NumPy 1.23.5
- Pytorch 1.10.0
- scikit-image 0.18.0
- scipy 1.9.3
- open3d 0.14.1
- GPUtil 1.4.0
- argparse 1.1
- trimesh 3.20.1
- plotly 5.13.0

# #
## Data ##
- Surface Reconstruction Benchmark
Surface Reconstruction Benchmark (SRB) is available in [Deep Geometric Prior repository](https://github.com/fwilliams/deep-geometric-prior). 

We provide *gargoyle* data of the SRB as an example in `./data/gargoyle.ply`.

- Thingi10K
Thingi10K is provided in [Thingi10K](https://ten-thousand-models.appspot.com/). 


# #
## Training PINC 

Adjust reconstruction/setup.conf to the path of the input point cloud:
```
train
{
    input_path = your_path
    ...
}
```
- run the model using the following command.
```
cd ./code
python run.py --points_batch 16384 --nepoch 100000 \\
                --conf 'setup.conf' --regularizer_type 'curl' \\
                --regularizer_coord 0.1 0.0001 0.0005 0.1 --epsilon 1
```
# #
## Test PINC ##
Before producing a meshed surface, adjust the input_path in reconstruction/setup.conf to the point cloud on which the model has been trained.

- Produce meshed surface:
```
python run.py --eval --is_continue --points_batch 16384 --conf 'setup.conf' \\
             --timestamp TIMESTAMP --checkpoint CHECKPOINT
```
- We provide one of our trained timestamp and checkpoint
```
python run.py --eval --is_continue --points_batch 16384 --conf 'setup.conf' \\
             --timestamp 'testcheckpoint' --checkpoint 'gargoyle'
```
