#!/bin/bash
# Utility script to clean up hanging NS-3 Docker containers

echo "🧹 Cleaning up hanging NS-3 Docker containers..."

# Count containers before cleanup
BEFORE=$(docker ps -a -q --filter "ancestor=gatv2_ns3_ids:marshallasch" --filter "ancestor=marshallasch/ns3" | wc -l | tr -d ' ')
echo "Found $BEFORE hanging containers"

if [ "$BEFORE" -gt 0 ]; then
    # Clean up containers
    docker ps -a -q --filter "ancestor=gatv2_ns3_ids:marshallasch" | xargs -r docker rm -f
    docker ps -a -q --filter "ancestor=marshallasch/ns3" | xargs -r docker rm -f
    
    # Count containers after cleanup
    AFTER=$(docker ps -a -q --filter "ancestor=gatv2_ns3_ids:marshallasch" --filter "ancestor=marshallasch/ns3" | wc -l | tr -d ' ')
    
    echo "✅ Cleaned up $(($BEFORE - $AFTER)) containers"
    
    if [ "$AFTER" -gt 0 ]; then
        echo "⚠️  $AFTER containers still remain"
        docker ps -a --filter "ancestor=gatv2_ns3_ids:marshallasch" --filter "ancestor=marshallasch/ns3"
    else
        echo "🎉 All NS-3 containers cleaned up successfully!"
    fi
else
    echo "✅ No hanging containers found - system is clean!"
fi
