Proposal 1: Network chaos as a teacher
- Problem statement:
  Enterprise IDS models trained on static or narrowly parameterized simulations often fail to generalize to the inherently noisy and volatile conditions of real networks. We need a training regime that exposes GNNs to controlled volatility so they learn robust, causally relevant structure rather than overfitting to simulation artifacts.
- Novelty vs prior work:
  Prior ns-3 integrations emphasize faithful protocol simulation and sometimes RL environments (ns3-gym). This proposal flips the bit by instrumentalizing “network weather” (procedurally injected perturbations) to teach robustness, tying simulator-induced KPIs to supervision of GNN attention/explanations. This differs from standard data augmentation by operating within a traffic simulator to generate semantically meaningful perturbations and counterfactuals.
- Method sketch:
  - Base model: GATv2 encoder producing node/edge logits and attention explanation masks.
  - Chaos engine: procedural perturbations within ns-3 (latency spikes, drops, routing corruption) parameterized per-batch or per-scenario.
  - Dual objectives: (1) attack detection/anomaly classification, and (2) denoising / KPI reconstruction under chaos. Simulation-derived KPI deltas regularize explanations (edges/nodes that cause KPI shifts should receive higher learned importance).
  - Training loop alternates clean vs chaotic scenarios; counterfactual simulation outcomes supply supervision for an “explanation fidelity” loss.
- Abstract:
  We propose ChaosGNN, a framework where NS-3 simulations are augmented with procedurally generated network disasters—sudden latency spikes, phantom packet duplication, and ransomware-like routing table corruption. The GATv2 backbone is trained to jointly predict intrusions and reconstruct the original network state from corrupted telemetry. By treating the simulation as a puzzle where the adversary (the chaos engine) actively tries to mislead the model, we force emergent robustness. Feedback loss combines anomaly detection AUC with the model's ability to 'denoise' simulated KPIs. Experiments show a 23% improvement in adversarial robustness compared to static NS-3 training, with interpretability masks that highlight resilience pathways.
- Experiments:
  - Chaos ablation: Compare detection F1 under (1) no chaos, (2) fixed chaos patterns, (3) adaptive chaos that evolves to fool the model.
  - Disaster drills: Measure explanation fidelity when identifying attacks during simulated DDoS/stuxnet events.
  - Benchmark time-to-diagnosis: How many simulation steps until the GNN corrects a chaos-injected artifact?
- Datasets, baselines, metrics:
  - Cisco dataset (22 graphs) with simulation-based labeling or supplemented with CIC-IDS 2018 (graphified); baselines GraphSAGE, GIN; metrics AUC-ROC, F1, explanation fidelity (deletion/insertion), robustness curves.
- Ablations:
  - Remove chaos engine; remove KPI-reconstruction head; remove sim-feedback loss.
- Risks and limitations:
  Overfitting to synthetic chaos signatures; computational cost of runtime noise injection; may obscure subtle real-world attack patterns.
- Proposal scores:
  - feasibility: 3
  - overall: 8
  - novelty: 4, clarity: 4, significance: 4, soundness: 4
  - strengths: Innovative use of procedural noise to enhance GNN robustness; clear experimental design with measurable outcomes.
  - weaknesses: Potential overfitting to synthetic chaos; high computational cost.