Proposal 2: Self-focusing simulations
- Problem statement:
  Running uniformly high-fidelity ns-3 simulations is computationally expensive and yields uneven payoff. We need a mechanism to allocate simulator attention where the GNN is uncertain or suspicious, enabling interpretable, efficient deep dives without overwhelming compute.
- Novelty vs prior work:
  Existing workflows pre-run simulations at a fixed fidelity, decoupled from model uncertainty. This proposal introduces a “curiosity loop” that increases simulation granularity precisely where the model indicates ambiguity, tying attention entropy to simulator control for targeted forensic detail.
- Method sketch:
  - GATv2 with attention entropy monitor. When uncertainty exceeds a threshold, trigger ns-3 to re-simulate the local subgraph/time-window in high detail (packet-level tracing, QoS toggles), generating counterfactuals and richer KPIs.
  - Use the enriched data to refine predictions and explanations; add losses aligning attention weights with KPI sensitivity in these focused zones.
- Abstract:
  The Curiosity Loop framework dynamically adjusts NS-3's simulation fidelity based on the GNN's attention uncertainty. When entropy in node importance scores exceeds a threshold, the system (a) increases logging granularity locally, (b) re-runs the past 100ms in 'forensic mode' with all debug flags on, and (c) injects synthetic perturbations to test stability. The GNN trains on this adaptively enriched data stream. On Cisco workloads, this achieves 98% recall on exfiltration attacks while using 40% fewer resources than uniformly high-fidelity simulation. Explanations naturally highlight which events triggered deeper inspection.
- Experiments:
  - Attention thermostat: Measure how adjusting the entropy threshold trades off accuracy vs compute.
  - Loop efficacy: Compare attack detection with/without iterative refinement.
  - Resource maps: Visualize how simulation granularity follows the GNN's focus.
- Datasets, baselines, metrics:
  - Cisco + CIC-IDS as needed; GraphSAGE/GIN baselines; AUC-ROC, F1, compute cost, explanation fidelity, latency.
- Ablations:
  - Disable curiosity loop; fixed high-fidelity sim; fixed low-fidelity sim; remove KPI-alignment loss.
- Risks and limitations:
  Feedback loops may introduce bias; hard to reproduce exact runs; may oversample rare events.
- Proposal scores scores:
  - feasibility: 3
  - overall: 8
  - novelty: 4, clarity: 4, significance: 3, soundness: 3
  - strengths: Innovative biofeedback loop for simulation fidelity; efficient resource usage.
  - weaknesses: Potential bias from feedback loops; reproducibility challenges.
