"""
Data loading and processing for GATv2-NS3 IDS.

IMPORTANT: This module now uses the FIXED data pipeline.
The old functions (load_dataset, split_dataset) are deprecated 
and should not be used as they create artificial graphs.

Use the new realistic data pipeline instead:
- network_graph_builder.create_realistic_nsl_kdd_graphs()
- attack_pattern_generator.inject_realistic_attacks_into_graphs()
"""

import warnings
from typing import List
from .network_graph_builder import create_realistic_nsl_kdd_graphs, NetworkGraphBuilder
from .attack_pattern_generator import inject_realistic_attacks_into_graphs, AttackPatternGenerator
from .nsl_kdd import NSLKDDDatasetLoader, create_nsl_kdd_dataset
from ..utils.common import GraphData


def load_dataset(path: str) -> List[GraphData]:
    """
    DEPRECATED: This function is no longer supported.
    
    Use create_real_dataset() for real NSL-KDD data processing.
    """
    raise RuntimeError(
        "load_dataset() is deprecated and no longer supported. "
        "Use create_nsl_kdd_dataset() for NSL-KDD data processing. "
        "No synthetic fallbacks are available in hardcore mode."
    )


def split_dataset(graphs: List[GraphData], train_ratio: float = 0.7, val_ratio: float = 0.15) -> tuple:
    """
    DEPRECATED: This function is no longer supported.
    """
    raise RuntimeError(
        "split_dataset() is deprecated and no longer supported. "
        "Use proper train/val/test splitting in the training scripts. "
        "No synthetic data utilities are available in hardcore mode."
    )


# Export the new, fixed components
__all__ = [
    'create_realistic_nsl_kdd_graphs',
    'inject_realistic_attacks_into_graphs', 
    'NetworkGraphBuilder',
    'AttackPatternGenerator',
    'NSLKDDDatasetLoader',
    'create_nsl_kdd_dataset',
    # Deprecated functions (for backwards compatibility)
    'load_dataset',
    'split_dataset'
]