#!/usr/bin/env python3
"""
Baseline Models Import Hub for GATv2-NS3 Hybrid IDS

This file serves as a centralized import hub for all baseline models.
Each model has its own standalone file for clarity and maintainability.
"""

# Import all baseline models from their standalone files
from .gin_ids import GIN_IDS
from .graphsage_ids import GraphSAGE_IDS
from .mlp_ids import MLP_IDS
from .random_forest_ids import RandomForest_IDS
from .logistic_regression_ids import LogisticRegression_IDS
from .xgboost_ids import XGBoostIDS

# Re-export for convenience
__all__ = [
    'GIN_IDS',
    'GraphSAGE_IDS', 
    'MLP_IDS',
    'RandomForest_IDS',
    'LogisticRegression_IDS',
    'XGBoostIDS'
]

# Alias for backward compatibility with train_baselines.py
NodeMLP = MLP_IDS
RandomForest_IDS = RandomForest_IDS  # Already correct name
XGBoost_IDS = XGBoostIDS