"""
Base classes for NS-3 simulation integration.
"""

from abc import ABC, abstractmethod
from typing import Dict, Any


class SimReport(dict):
    """Simulation report containing network KPIs and metadata."""
    
    def __init__(self, data: Dict[str, Any]):
        super().__init__(data)
        
        # Ensure required fields exist
        if "latency_ms" not in self:
            self["latency_ms"] = 0.0
        if "throughput_mbps" not in self:
            self["throughput_mbps"] = 0.0
        if "drop_rate" not in self:
            self["drop_rate"] = 0.0


class NS3ClientBase(ABC):
    """Abstract base class for NS-3 simulation clients."""
    
    @abstractmethod
    def run_scenario(self, scenario_spec: Dict[str, Any]) -> SimReport:
        """
        Run a network simulation scenario.
        
        Args:
            scenario_spec: Dictionary containing scenario specification
            
        Returns:
            SimReport with simulation results and KPIs
        """
        raise NotImplementedError
