
from typing import Dict, Any
import hashlib, json

class SimCache:
    def __init__(self):
        self.store_map = {}
    def _key(self, graph_id: str, subgraph_id: str, scenario_id: str) -> str:
        return f"{graph_id}::{subgraph_id}::{scenario_id}"
    def lookup(self, graph_id: str, subgraph_id: str, scenario_id: str):
        return self.store_map.get(self._key(graph_id, subgraph_id, scenario_id))
    def store(self, graph_id: str, subgraph_id: str, scenario_id: str, sim_report: Dict[str, Any]):
        self.store_map[self._key(graph_id, subgraph_id, scenario_id)] = sim_report

def scenario_hash(scenario_spec: Dict[str, Any]) -> str:
    s = json.dumps(scenario_spec, sort_keys=True)
    return hashlib.md5(s.encode()).hexdigest()
