import pathlib
import numpy as np
import os

"""
Directions: set task name, action mode (e.g. hybrid, ego, etc), and the correct normalization params (usually just mean/std).
Make sure action mode is exactly what you want!
"""

### Task parameters
DATA_DIR = os.getenv("PATH_TO_DATASET")
TASK_CONFIGS = {
    'suturing_dot':{
        'dataset_dir': DATA_DIR,
        'goal_condition_style': 'dot',
        'num_episodes': 1878,
        'num_episodes_val': 12,
        'tissue_samples_ids': [1, 2, 3, 4, 5, 6, 7, 8, 9],
        'tissue_samples_ids_val': [10],
        'camera_file_suffixes':  ["_left.jpg", "_psm1.jpg", "_psm2.jpg"],
        'episode_len': 500, # not to be confused with number of demos
        'action_mode': ['hybrid',
        {'mean': np.array([0.0013053844357952917, -0.0002931026323686054, 0.0010067677628530166, 0.9792426578378564, 0.00633010617872394, 0.008519744243388654, -0.0037000856702325237, 0.9617303136948773, 0.022964645864674, -0.1893737763206796, -0.0010204155192546308, 0.0005886301092789384, 0.0005181695563305222, 0.9822972043895222, -0.004034582858768097, -0.0010051510644155787, 0.00519588082601343, 0.9835193961875751, 0.02009281093373397, 0.02290887882531041]),

        'std': np.array([0.01, 0.010063501827354415, 0.01, 0.04283547255115624, 0.14917728155639307, 0.12993237372904196, 0.15323637514029312, 0.07868397018179502, 0.21180458988721762, 0.3492246041207715, 0.01, 0.01, 0.01, 0.04161559730886642, 0.1326190844531802, 0.1255198572370315, 0.13476447490667523, 0.04026385111090807, 0.11169708004244636, 0.3058532496359794]) }],
        'norm_scheme': 'std',
        'save_frequency': 50,
        'camera_names': ['left', 'left_wrist', 'right_wrist'],
        },
    
}

